import { DeviceFilter } from '../Device/deviceFilter';
import { IOriginatorAware } from '../Originator/Originator';
import { DeviceActionType } from './Enums';
import { LogData } from './Types';
export interface CreateBulkOperation<T extends DeviceActionType> extends IOriginatorAware {
    uid?: string;
    name?: string;
    filter: DeviceFilter;
    /** Organization uids afftected devices belong to */
    organizationUids: string[];
    schedule?: {
        datetime: Date;
        timezone?: string;
        /** Resolve filter at the time of execution instead of creation time */
        deferFilter?: boolean;
    };
    rollingUpdate?: {
        batchSize: number;
        /** time in ms */
        batchDelay?: number;
        /** How many devices is allowed to fail bulk operation, value in % */
        stopThreshold?: number;
    };
    operationType: T;
    data: LogData[T];
    isDraft?: boolean;
}
export interface StopBulkOperation extends IOriginatorAware {
    uid: string;
}
export interface PauseBulkOperation extends IOriginatorAware {
    uid: string;
}
export interface ResumeBulkOperation extends IOriginatorAware {
    uid: string;
    rollingUpdate?: {
        batchSize: number;
        /** time in ms */
        batchDelay?: number;
        /** How many devices is allowed to fail bulk operation, value in % */
        stopThreshold?: number;
    };
}
export interface ArchiveBulkOperation extends IOriginatorAware {
    uid: string;
}
export interface CheckActiveBulkOperations extends IOriginatorAware {
}
