import { AlertType } from '../AlertType';
import { AlertConditionPair } from '../AlertCondition';
import { ValidationOutput } from '../../Validation/Validation';
export declare const wifiEthernet: string[];
export declare const inputSource: string[];
export interface ICondition {
    type: string;
    op: any;
}
export default function isAlertConditionValid(conditions: unknown, alertType: AlertType): ValidationOutput<AlertConditionPair<AlertType>>;
export declare class InvalidBooleanCondition extends Error {
    constructor(condition: unknown);
}
export declare class InvalidOccurrencesInTimeRangeCondition extends Error {
    constructor(condition: unknown);
}
export declare class InvalidStringOccurencesInTimeRangeCondition extends Error {
    constructor(condition: unknown);
}
export declare class InvalidNumericRangeCondition extends Error {
    constructor(condition: unknown);
}
export declare class InvalidCondition extends Error {
    constructor(condition: unknown);
}
export declare class InvalidConditionToAlertType extends Error {
    constructor(condition: unknown, alertType: unknown);
}
