"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlertType = void 0;
/**
 * The types of alerts mainly for internal logic of alert creation.
 * Additionally for simple describe for user in UI and filtering.
 */
var AlertType;
(function (AlertType) {
    /**
     * Device alert type which is based on device basic information from device, deviceInfo and related entities.
     */
    AlertType["DEVICE"] = "DEVICE";
    /**
     * Policy alert type which is based on violation of rules of policies.
     */
    AlertType["POLICY"] = "POLICY";
    /**
     * Applet alert type which is based on applet related information and AppletCommandDispatch feature.
     */
    AlertType["APPLET"] = "APPLET";
})(AlertType || (exports.AlertType = AlertType = {}));
