"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccountLicensesSchema = exports.RoleSchema = exports.Role = exports.AccountCreationReasonSchema = exports.AccountCreationReason = exports.AccessLevelSchema = exports.AccessLevel = void 0;
const zod_1 = require("zod");
const License_1 = require("../License/License");
/**
 *  Defines the user's level in the application
 *  @preview  just after the registration, should be disallowed to do anything until is his accessLevel changed by the admin
 *  @open     basic level with limited rights
 *  @platform common level for paid customers
 *  @archived aka deleted, but the data remains. Archived user may not log in, but may be un-archived by admin
 *  @admin    aka Chuck Norris with unlimited rights for sOS stuff, but be aware that with great power comes the great responsibility
 */
var AccessLevel;
(function (AccessLevel) {
    AccessLevel["Preview"] = "preview";
    AccessLevel["Open"] = "open";
    AccessLevel["Platform"] = "platform";
    AccessLevel["Archived"] = "archived";
    AccessLevel["Admin"] = "admin";
})(AccessLevel || (exports.AccessLevel = AccessLevel = {}));
exports.AccessLevelSchema = zod_1.z.nativeEnum(AccessLevel);
var AccountCreationReason;
(function (AccountCreationReason) {
    AccountCreationReason["SignUp"] = "signup";
    AccountCreationReason["Invite"] = "invite";
})(AccountCreationReason || (exports.AccountCreationReason = AccountCreationReason = {}));
exports.AccountCreationReasonSchema = zod_1.z.nativeEnum(AccountCreationReason);
// Defines the user privilege role
// Role may be attached to account-organization or any other account-otherEntity relation (IPrivilegeEntity)
var Role;
(function (Role) {
    Role["Owner"] = "owner";
    Role["Master"] = "master";
    Role["User"] = "user";
    Role["Guest"] = "guest";
})(Role || (exports.Role = Role = {}));
exports.RoleSchema = zod_1.z.nativeEnum(Role);
exports.AccountLicensesSchema = zod_1.z.record(zod_1.z.string(), zod_1.z.array(License_1.LicenseSchema));
