"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeviceClient = void 0;
const debug_1 = __importDefault(require("debug"));
const messages_1 = require("../messages");
const client_1 = require("../client");
const socket_1 = require("../socket");
const deferred_1 = require("@signageos/lib/dist/Promise/deferred");
const debug = (0, debug_1.default)('@signageos/remote-desktop:DeviceClient');
const DEFAULT_FREQUENCY_MS = 500;
class DeviceClient {
    constructor(takeScreenshot, duid, eventDispatcher) {
        this.takeScreenshot = takeScreenshot;
        this.duid = duid;
        this.eventDispatcher = eventDispatcher;
        this.takingScreenshot = false;
        this.browserConnected = false;
    }
    start(options) {
        return __awaiter(this, void 0, void 0, function* () {
            debug('Starting DeviceClient', options);
            if (this.socket) {
                throw new Error('Already started');
            }
            yield this.connectWebSocket(this.duid, options);
            debug('Connected to WebSocket');
            const { connectedPromise } = this.bindSocketEvents(options);
            return (0, client_1.createStartedClient)(this, connectedPromise, options);
        });
    }
    stop() {
        return __awaiter(this, void 0, void 0, function* () {
            var _a;
            debug('Stopping DeviceClient');
            if (!this.socket) {
                throw new Error('Not started');
            }
            clearInterval(this.intervalHandler);
            this.intervalHandler = undefined;
            (_a = this.socket) === null || _a === void 0 ? void 0 : _a.close();
            this.socket = undefined;
        });
    }
    isStarted() {
        return Boolean(this.socket);
    }
    isBrowserConnected() {
        return this.browserConnected;
    }
    connectWebSocket(duid, options) {
        return __awaiter(this, void 0, void 0, function* () {
            const serverUri = `${options.serverUrl}/device?duid=${duid}`;
            this.socket = yield (0, socket_1.connectSocket)(serverUri);
        });
    }
    bindSocketEvents(options) {
        if (!this.socket) {
            throw new Error('Socket not initialized');
        }
        const connectedDeferred = (0, deferred_1.createDeferred)();
        this.socket.on(messages_1.Message.MouseEvent, (payload) => __awaiter(this, void 0, void 0, function* () {
            debug('MouseEvent', payload);
            yield this.eventDispatcher.dispatchEvent(payload);
        }));
        this.socket.on(messages_1.Message.KeyEvent, (payload) => __awaiter(this, void 0, void 0, function* () {
            debug('KeyEvent', payload);
            yield this.eventDispatcher.dispatchEvent(payload);
        }));
        this.socket.on(messages_1.Message.ButtonEvent, (payload) => __awaiter(this, void 0, void 0, function* () {
            debug('ButtonEvent', payload);
            console.log('ButtonEvent', payload);
            yield this.eventDispatcher.dispatchEvent(payload);
        }));
        this.socket.on(messages_1.Message.BrowserConnected, () => {
            var _a, _b;
            debug('BrowserConnected');
            this.browserConnected = true;
            (_a = options.onStatus) === null || _a === void 0 ? void 0 : _a.call(options, true);
            connectedDeferred.resolve();
            const frequencyMs = (_b = options.frequencyMs) !== null && _b !== void 0 ? _b : DEFAULT_FREQUENCY_MS;
            this.intervalHandler = setInterval(this.recordScreenshot.bind(this), frequencyMs);
        });
        this.socket.on(messages_1.Message.BrowserDisconnected, () => {
            var _a;
            debug('BrowserDisconnected');
            this.browserConnected = false;
            (_a = options.onStatus) === null || _a === void 0 ? void 0 : _a.call(options, false);
            clearInterval(this.intervalHandler);
            this.intervalHandler = undefined;
        });
        return {
            connectedPromise: connectedDeferred.promise,
        };
    }
    recordScreenshot() {
        return __awaiter(this, void 0, void 0, function* () {
            debug('Taking screenshot');
            if (this.takingScreenshot) {
                throw new Error('Already taking screenshot');
            }
            this.takingScreenshot = true;
            try {
                const screenshot = yield this.takeScreenshot();
                debug('Screenshot taken', screenshot);
                if (!this.socket) {
                    throw new Error('Socket not initialized');
                }
                const payload = screenshot;
                this.socket.emit(messages_1.Message.ScreenshotRecorded, payload);
            }
            finally {
                this.takingScreenshot = false;
            }
        });
    }
}
exports.DeviceClient = DeviceClient;
//# sourceMappingURL=DeviceClient.js.map