import { EventPayload } from '../messages';
import { Client, ClientOptions, StartedClient } from '../client';
interface Options extends ClientOptions {
    serverUrl: string;
    frequencyMs?: number;
}
export interface EventDispatcher {
    dispatchEvent(event: EventPayload): Promise<void>;
}
interface Screenshot {
    screenshotUri: string;
    width: number;
    height: number;
}
export declare class DeviceClient implements Client {
    private readonly takeScreenshot;
    private readonly duid;
    private readonly eventDispatcher;
    private takingScreenshot;
    private intervalHandler;
    private browserConnected;
    private socket;
    constructor(takeScreenshot: () => Promise<Screenshot>, duid: string, eventDispatcher: EventDispatcher);
    start(options: Options): Promise<StartedClient>;
    stop(): Promise<void>;
    isStarted(): boolean;
    isBrowserConnected(): boolean;
    private connectWebSocket;
    private bindSocketEvents;
    private recordScreenshot;
}
export {};
