import { detectModuleRootPath } from '@signageos/lib/dist/Path/detector';
import { NodeEnvironments } from '@signageos/common-types/dist/Environment/environment';
import { rootPathSchema, packageConfigSchema, environmentVariablesSchema } from '../src/Lib/Validation/validation';

const environment = process.env.NODE_ENV ?? NodeEnvironments.Dev;

const packageConfig = packageConfigSchema.parse(require('../package.json'));

const rootPath = rootPathSchema.parse(detectModuleRootPath(packageConfig.name));

const configPath = rootPath + '/config';

try {
	let localEnv: any;
	if (environment === NodeEnvironments.Dev) {
		localEnv = require(`./env.${environment}.json`);
	} else if (environment === NodeEnvironments.Test) {
		localEnv = require(`./env.${environment}.json`);
	} else if (environment === NodeEnvironments.Production) {
		localEnv = require(`./env.${environment}.json`);
	} else {
		console.warn(`Unsupported environment ${environment}. But try it for server anyway`);
		localEnv = require(configPath + './env.' + environment + '.json');
	}
	process.env = Object.assign(process.env, localEnv);
} catch (err) {
	console.info(`Not using overriding env.${environment}.json file`);
}

const environmentVariables = environmentVariablesSchema.parse(process.env);

export const parameters = {
	app: {
		name: environmentVariables.SERVICE_NAME,
		version: packageConfig.version,
		port: environmentVariables.PORT,
	},
	environment: environmentVariables.NODE_ENV,
	paths: {
		rootPath,
		testsPath: rootPath + '/tests',
		distPath: rootPath + '/dist',
		configPath,
	},
	mongo: {
		platform: {
			dsn: environmentVariables.mongodb_platform_dsn,
		},
	},
	sentry: {
		enabled: environmentVariables.sentry_enabled,
		config: {
			dsn: environmentVariables.sentry_dsn,
			release: packageConfig.version,
			environment,
			tags: {
				application: environmentVariables.SERVICE_NAME,
			},
		},
	},
};

export type Parameters = typeof parameters;

export default parameters;
