#!/usr/bin/env node

const fs = require('fs');

function exactDepsMutable(deps, lock) {
	deps = deps || {};
	const depNames = Object.keys(deps);
	for (const depName of depNames) {
		const lockDep = lock.dependencies[depName];
		const currentVersion = lockDep.version;
		deps[depName] = currentVersion;
	}
}

const packagePath = process.cwd() + '/package.json';
const packageLockPath = process.cwd() + '/package-lock.json';
const package = require(packagePath);
const packageLock = require(packageLockPath);

exactDepsMutable(package.dependencies, packageLock);
exactDepsMutable(package.devDependencies, packageLock);

fs.writeFileSync(packagePath, JSON.stringify(package, undefined, 2) + '\n');
