const packageJson = require('../package.json');
const dependencies = packageJson.dependencies || {};
const devDependencies = packageJson.devDependencies || {};

const whitelist = ['@signageos/codestyle'];
const packages = Object.keys(dependencies).concat(Object.keys(devDependencies));

let forbiddenPackages = packages.filter((package) => package.match('@signageos/*'));
forbiddenPackages = forbiddenPackages.filter((package) => !whitelist.includes(package));

if (forbiddenPackages.length > 0) {
	console.error(`    Forbidden packages ${forbiddenPackages.join(', ')} found in package.json. 
@signageos/* modules can't be used as dependencies because they are private while this module is public and may only use public dependencies.
Only exceptions are whitelisted dependencies: ${whitelist.join(', ')}
`);
	process.exit(1);
}
