"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapObject = exports.convertObjectUndefinedPropertiesToNull = exports.getObjectKeys = exports.getObjectWithOmittedValuesBy = void 0;
const lodash_1 = require("lodash");
const isObject = (value) => !(0, lodash_1.isString)(value) && !(0, lodash_1.isEmpty)(value);
const isTypeOf = (value, comparedValue) => {
    if ((0, lodash_1.isUndefined)(value) && (0, lodash_1.isUndefined)(comparedValue)) {
        return true;
    }
    if ((0, lodash_1.isNull)(value) && (0, lodash_1.isNull)(comparedValue)) {
        return true;
    }
    if ((0, lodash_1.isNumber)(value) && (0, lodash_1.isNumber)(comparedValue) && value === comparedValue) {
        return true;
    }
    if ((0, lodash_1.isString)(value) && (0, lodash_1.isString)(comparedValue) && value === comparedValue) {
        return true;
    }
    if ((0, lodash_1.isDate)(value) && (0, lodash_1.isDate)(comparedValue) && value === comparedValue) {
        return true;
    }
    return false;
};
const getOmittedArray = (array, omittedValue) => {
    let iteratedValues = [];
    for (const item of array) {
        if (isTypeOf(item, omittedValue)) {
            continue;
        }
        else if (isObject(item)) {
            iteratedValues.push(Object.assign({}, (0, exports.getObjectWithOmittedValuesBy)(item, omittedValue)));
            continue;
        }
        else {
            iteratedValues.push(item);
            continue;
        }
    }
    return iteratedValues;
};
/**
 * @param input can be any object
 * @param omittedValue value which should be omitted, currently supports `undefined`,
 *  `null`, `exact number`, `exact string` and `exact date`
 * @returns the same object recursively but without fields with omitted value
 */
const getObjectWithOmittedValuesBy = (input, omittedValue) => {
    let result = {};
    for (const key in input) {
        const value = input[key];
        // Validates omitted value
        if (isTypeOf(value, omittedValue)) {
            continue;
        }
        else if ((0, lodash_1.isArray)(value)) {
            result = Object.assign(Object.assign({}, result), { [key]: getOmittedArray(value, omittedValue) });
            continue;
        }
        else if (isObject(value)) {
            result = Object.assign(Object.assign({}, result), { [key]: Object.assign({}, (0, exports.getObjectWithOmittedValuesBy)(value, omittedValue)) });
            continue;
        }
        result = Object.assign(Object.assign({}, result), { [key]: value });
    }
    return result;
};
exports.getObjectWithOmittedValuesBy = getObjectWithOmittedValuesBy;
/**
 * Better typed version of Object.keys function returning Array of keyof types instead of Array of string types.
 */
exports.getObjectKeys = Object.keys;
function convertObjectUndefinedPropertiesToNull(obj) {
    const result = {};
    for (const key in obj) {
        const value = obj[key];
        if (value === undefined) {
            result[key] = null;
        }
        else {
            result[key] = value;
        }
    }
    return result;
}
exports.convertObjectUndefinedPropertiesToNull = convertObjectUndefinedPropertiesToNull;
function mapObject(settings, transform) {
    const timerSettings = {};
    for (const timerType of (0, exports.getObjectKeys)(settings)) {
        timerSettings[timerType] = transform(settings[timerType]);
    }
    return timerSettings;
}
exports.mapObject = mapObject;
//# sourceMappingURL=object.js.map