"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function* asyncIterator(collection) {
    let length = 1;
    collection = collection.then(function (items) {
        if (items) {
            length = items.length;
        }
        return items;
    });
    for (let i = 0; i < length; i++) {
        yield collection.then((items) => {
            if (!items) {
                return undefined;
            }
            return items[i];
        });
    }
}
exports.default = asyncIterator;
if (!Symbol.asyncIterator) {
    Symbol.asyncIterator = asyncIterator;
}
//# sourceMappingURL=asyncIterator.js.map