"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertTimersToShortWeekdayTimerSettings = exports.convertTimersToLongWeekdayTimerSettings = exports.convertLegacyTimerToShortWeekdayTimer = exports.convertShortWeekdayTimerSettingsToLegacyTimerSettings = exports.convertLongWeekdayTimerSettingsToLegacyTimerSettings = void 0;
const object_1 = require("../Utils/object");
const convertWeekday_1 = require("./convertWeekday");
function convertLongWeekdayTimerSettingsToLegacyTimerSettings(settings) {
    return (0, object_1.mapObject)(settings, (_a) => {
        var { weekdays } = _a, t = __rest(_a, ["weekdays"]);
        return (Object.assign(Object.assign({}, t), convertWeekday_1.convertWeekday.fromLong(weekdays).toLegacy()));
    });
}
exports.convertLongWeekdayTimerSettingsToLegacyTimerSettings = convertLongWeekdayTimerSettingsToLegacyTimerSettings;
function convertShortWeekdayTimerSettingsToLegacyTimerSettings(settings) {
    return (0, object_1.mapObject)(settings, (_a) => {
        var { weekdays } = _a, t = __rest(_a, ["weekdays"]);
        return (Object.assign(Object.assign({}, t), convertWeekday_1.convertWeekday.fromShort(weekdays).toLegacy()));
    });
}
exports.convertShortWeekdayTimerSettingsToLegacyTimerSettings = convertShortWeekdayTimerSettingsToLegacyTimerSettings;
function convertLegacyTimerToShortWeekdayTimer(settings) {
    return (0, object_1.mapObject)(settings, (_a) => {
        var { sun, mon, tue, wed, thu, fri, sat } = _a, t = __rest(_a, ["sun", "mon", "tue", "wed", "thu", "fri", "sat"]);
        return (Object.assign(Object.assign({}, t), { weekdays: convertWeekday_1.convertWeekday.fromLegacy({ sun, mon, tue, wed, thu, fri, sat }).toShort() }));
    });
}
exports.convertLegacyTimerToShortWeekdayTimer = convertLegacyTimerToShortWeekdayTimer;
function convertTimersToLongWeekdayTimerSettings(shortWeekdayTimer) {
    const timers = {};
    for (let _a of shortWeekdayTimer) {
        const { weekdays } = _a, t = __rest(_a, ["weekdays"]);
        timers[t.type] = Object.assign(Object.assign({}, t), { weekdays: convertWeekday_1.convertWeekday.fromShort(weekdays).toLong() });
    }
    return timers;
}
exports.convertTimersToLongWeekdayTimerSettings = convertTimersToLongWeekdayTimerSettings;
function convertTimersToShortWeekdayTimerSettings(shortWeekdayTimer) {
    const timers = {};
    for (const timerSetting of shortWeekdayTimer) {
        timers[timerSetting.type] = {
            type: timerSetting.type,
            timeOn: timerSetting.timeOn,
            timeOff: timerSetting.timeOff,
            weekdays: timerSetting.weekdays,
        };
    }
    return timers;
}
exports.convertTimersToShortWeekdayTimerSettings = convertTimersToShortWeekdayTimerSettings;
//# sourceMappingURL=converters.js.map