export declare function capitalize<T extends string>(word: T): Capitalize<T>;
export declare function uncapitalize<T extends string>(word: T): Uncapitalize<T>;
/**
 * Get first word in camelCase string.
 * If it is not camelCase, it returns null.
 */
export declare function getFirstCamelCaseWord(varName: string): string | null;
/**
 * Get first word in PascalCase string.
 * If it is not PascalCase, it returns null.
 */
export declare function getFirstPascalCaseWord(varName: string): string | null;
/**
 * Combines functions `getFirstCamelCaseWord` and `getFirstPascalCaseWord`.
 * It detects input variable name format and returns first word.
 * If it is not camelCase or PascalCase, it returns null.
 */
export declare function getFirstWord(varName: string): string | null;
/**
 * Converts camelCase/PascalCase to PascalCase
 * The argument has to be one of the following:
 * PascalCase
 * camelCase
 */
export declare function toPascalCase(camelVarName: string, maxShortcutLength?: number): string | null;
/**
 * Converts PascalCase/camelCase to camelCase
 * The argument has to be one of the following:
 * PascalCase
 * camelCase
 */
export declare function toCamelCase(pascalVarName: string, maxShortcutLength?: number): string | null;
