"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.routeMetrics = void 0;
/**
 * Serves metrics for Prometheus
 */
const routeMetrics = ({ router, metricsClient }) => {
    // TODO: Prometheus client shouldn't be on public server. The endpoints shouldn't be reachable from outside
    router.get('/metrics', (_req, res) => __awaiter(void 0, void 0, void 0, function* () {
        try {
            return metricsClient.serve(res);
        }
        catch (err) {
            return res.status(500).send(`Error scraping prometheus metrics: ${err}`);
        }
    }));
};
exports.routeMetrics = routeMetrics;
//# sourceMappingURL=metrics.js.map