"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAppExpress = void 0;
const express = __importStar(require("express"));
const accessLogMiddleware_1 = require("../middleware/accessLogMiddleware");
const logging_1 = require("../../../Logging/logging");
const router_1 = require("../routes/app/router");
const expressFactory_1 = require("./expressFactory");
const accessLogLogger = logging_1.logger.createNamespace('accessLog');
function createAppExpress(args) {
    const { accessLogCallback } = args;
    const app = (0, expressFactory_1.createExpressApp)();
    // Log all requests
    app.use((0, accessLogMiddleware_1.accessLogMiddleware)((accessLog, req, res) => {
        accessLogLogger.info(`${accessLog.method} ${accessLog.path}`, Object.assign(Object.assign({}, accessLog), accessLogCallback === null || accessLogCallback === void 0 ? void 0 : accessLogCallback(accessLog, req, res)));
    }));
    const router = express.Router();
    (0, router_1.routeApp)(Object.assign(Object.assign({}, args), { router }));
    app.use('/', router);
    return app;
}
exports.createAppExpress = createAppExpress;
//# sourceMappingURL=app.js.map