export type IDeferred<T> = {
    promise: Promise<T>;
    resolve: (value: T) => void;
    reject: (error: Error) => void;
};
/**
 * It creates outside controlled promise so you can do the resole and reject outside the Promise constructor callback.
 * In standard Promise instantiating, you have to do all logic inside the constructor callback.
 */
export declare function createDeferred<T>(): IDeferred<T>;
