"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAwsNpmCredentialsProvider = exports.createStaticNpmCredentialsProvider = exports.createDefaultNpmCredentialsProvider = void 0;
const AWS = __importStar(require("aws-sdk"));
/**
 * Uses credentials from environment variables, if present
 */
function createDefaultNpmCredentialsProvider() {
    return () => __awaiter(this, void 0, void 0, function* () {
        return ({
            host: process.env.NPM_REGISTRY_HOST,
            url: process.env.NPM_REGISTRY_URL,
            authToken: process.env.NPM_AUTH_TOKEN,
        });
    });
}
exports.createDefaultNpmCredentialsProvider = createDefaultNpmCredentialsProvider;
function createStaticNpmCredentialsProvider(credentials) {
    return () => __awaiter(this, void 0, void 0, function* () { return credentials; });
}
exports.createStaticNpmCredentialsProvider = createStaticNpmCredentialsProvider;
function createAwsNpmCredentialsProvider({ domain, domainOwner, repository, region, }) {
    const codeArtifact = new AWS.CodeArtifact({ region });
    return () => __awaiter(this, void 0, void 0, function* () {
        const { repositoryEndpoint } = yield codeArtifact
            .getRepositoryEndpoint({
            domain,
            domainOwner,
            repository,
            format: 'npm',
        })
            .promise();
        if (!repositoryEndpoint) {
            throw new Error("Couldn't get repository endpoint");
        }
        const { authorizationToken } = yield codeArtifact.getAuthorizationToken({ domain, domainOwner }).promise();
        if (!authorizationToken) {
            throw new Error("Couldn't get authorization token");
        }
        return {
            host: repositoryEndpoint.replace(/^https?:\/\//, '').replace(/\/$/, ''),
            url: repositoryEndpoint,
            authToken: authorizationToken,
        };
    });
}
exports.createAwsNpmCredentialsProvider = createAwsNpmCredentialsProvider;
//# sourceMappingURL=NpmCredentialsProvider.js.map