"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useRavenLogging = void 0;
const Raven = __importStar(require("raven"));
function useRavenLogging() {
    // override default console logging
    const consoleWarn = console.warn;
    const consoleError = console.error;
    console.warn = (message, ...optionalParams) => {
        consoleWarn.call(console, message, ...optionalParams);
        if (typeof message !== 'string' || !message.startsWith('raven')) {
            captureRaven('warning', 'warn', message, ...optionalParams);
        }
    };
    console.error = (message, ...optionalParams) => {
        consoleError.call(console, message, ...optionalParams);
        if (typeof message !== 'string' || !message.startsWith('raven')) {
            captureRaven('error', 'error', message, ...optionalParams);
        }
    };
}
exports.useRavenLogging = useRavenLogging;
function captureRaven(level, source, message, ...optionalParams) {
    const options = {
        level,
        tags: {
            source,
        },
        extra: optionalParams,
    };
    if (message instanceof Error) {
        Raven.captureException(message, options);
    }
    else {
        if (typeof message === 'string') {
            message = message;
        }
        else {
            message = JSON.stringify(message);
        }
        Raven.captureMessage(message, options);
    }
}
//# sourceMappingURL=raven.js.map