"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTmpDirectory = void 0;
const os_1 = require("os");
const fs_extra_1 = require("fs-extra");
const path_1 = require("path");
/**
 * Creates a tmp directory
 *
 * @returns path to created tmp directory and callback to delete it once it's not needed anymore
 */
function createTmpDirectory(namePrefix) {
    return __awaiter(this, void 0, void 0, function* () {
        const dir = (0, os_1.tmpdir)();
        const path = yield (0, fs_extra_1.mkdtemp)((0, path_1.join)(dir, namePrefix));
        const cleanup = () => (0, fs_extra_1.remove)(path);
        return { path, cleanup };
    });
}
exports.createTmpDirectory = createTmpDirectory;
//# sourceMappingURL=tmpDir.js.map