"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sassPlugin = void 0;
const path = __importStar(require("path"));
const fs = __importStar(require("fs"));
const sass_1 = require("sass");
const css_tree_1 = require("css-tree");
const crypto_1 = require("crypto");
const sassPlugin = () => ({
    name: 'sass',
    setup(build) {
        return __awaiter(this, void 0, void 0, function* () {
            build.onResolve({ filter: /\.sass$/ }, (args) => ({
                path: path.resolve(args.resolveDir, args.path),
                namespace: 'sass',
            }));
            build.onLoad({ filter: /.*/, namespace: 'sass' }, (args) => __awaiter(this, void 0, void 0, function* () {
                const compiled = yield (0, sass_1.compileStringAsync)((yield fs.promises.readFile(args.path)).toString('utf-8'), {
                    syntax: 'indented',
                    url: new URL('file://' + args.path),
                });
                if (args.path.endsWith('.module.sass')) {
                    const ast = (0, css_tree_1.parse)(compiled.css);
                    const classMap = new Map();
                    (0, css_tree_1.walk)(ast, {
                        visit: 'ClassSelector',
                        enter(node) {
                            const transformed = `m-${node.name}-${(0, crypto_1.createHash)('md5').update(args.path).digest('hex').slice(0, 10)}`;
                            classMap.set(node.name, transformed);
                            node.name = transformed;
                        },
                    });
                    return {
                        contents: `
            import "data:text/css,${encodeURI((0, css_tree_1.generate)(ast))}";
            const result = ${JSON.stringify(Object.fromEntries([...Array.from(classMap)].map(([k, v]) => [k, v])))};
            export default result;
          `,
                    };
                }
                else {
                    return {
                        contents: compiled.css,
                        loader: 'css',
                    };
                }
            }));
        });
    },
});
exports.sassPlugin = sassPlugin;
//# sourceMappingURL=sass.js.map