"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeoutError = exports.waitUntilNotNull = exports.waitUntil = void 0;
const timeout_ts_1 = __importDefault(require("timeout-ts"));
/**
 * Repeatedly calls predicate until it returns a truthy value.
 * @returns the first truthy value returned by predicate
 */
const waitUntil = (predicate, interval = 100) => __awaiter(void 0, void 0, void 0, function* () {
    while (true) {
        const result = yield predicate();
        if (result) {
            return result;
        }
        yield (0, timeout_ts_1.default)(interval);
    }
});
exports.waitUntil = waitUntil;
/**
 * Repeatedly calls resultCallback until it returns a non-null value.
 * @throws TimeoutError if resultCallback does not return a non-null value within the specified timeoutMs
 * @returns the first non-null value returned by resultCallback
 */
function waitUntilNotNull(resultCallback, options = {}) {
    var _a, _b;
    return __awaiter(this, void 0, void 0, function* () {
        // Default options
        options.intervalMs = (_a = options.intervalMs) !== null && _a !== void 0 ? _a : 1e3;
        options.timeoutMs = (_b = options.timeoutMs) !== null && _b !== void 0 ? _b : 30e3;
        const startTime = new Date().valueOf();
        while (startTime + options.timeoutMs > new Date().valueOf()) {
            const result = yield resultCallback();
            if (result === null) {
                yield (0, timeout_ts_1.default)(options.intervalMs);
            }
            else {
                return result;
            }
        }
        throw new TimeoutError(options.timeoutMs);
    });
}
exports.waitUntilNotNull = waitUntilNotNull;
class TimeoutError extends Error {
    constructor(timeoutMs) {
        super(`Wait until has timed-out after ${timeoutMs} ms`);
        this.timeoutMs = timeoutMs;
    }
}
exports.TimeoutError = TimeoutError;
/** @deprecated use named import instead */
exports.default = exports.waitUntil;
//# sourceMappingURL=waitUntil.js.map