import { z } from 'zod';
/**
 * Schema for integer string
 *
 * Parses a string into an integer or throws an error if the string is not a valid integer.
 */
export declare const intSchema: z.ZodEffects<z.ZodEffects<z.ZodString, number, string>, number, string>;
/**
 * Schema for boolean string
 *
 * Parses a string into a boolean or throws an error if the string is not a valid boolean.
 * Accepted values are 'true', 'false', '1', '0'
 */
export declare const boolSchema: z.ZodEffects<z.ZodOptional<z.ZodString>, boolean, string | undefined>;
/**
 * Schema for JSON string
 *
 * Parses a string into a JSON object or throws an error if the string is not a valid JSON
 */
export declare const jsonStringSchema: z.ZodEffects<z.ZodString, any, string>;
/**
 * Schema for package.json
 */
export declare const packageConfigSchema: z.ZodObject<{
    name: z.ZodString;
    version: z.ZodString;
    dependencies: z.ZodDefault<z.ZodRecord<z.ZodString, z.ZodString>>;
    devDependencies: z.ZodDefault<z.ZodRecord<z.ZodString, z.ZodString>>;
    peerDependencies: z.ZodDefault<z.ZodRecord<z.ZodString, z.ZodString>>;
    optionalPeerDependencies: z.ZodDefault<z.ZodRecord<z.ZodString, z.ZodString>>;
    gitHead: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    name: string;
    version: string;
    dependencies: Record<string, string>;
    devDependencies: Record<string, string>;
    peerDependencies: Record<string, string>;
    optionalPeerDependencies: Record<string, string>;
    gitHead?: string | undefined;
}, {
    name: string;
    version: string;
    dependencies?: Record<string, string> | undefined;
    devDependencies?: Record<string, string> | undefined;
    peerDependencies?: Record<string, string> | undefined;
    optionalPeerDependencies?: Record<string, string> | undefined;
    gitHead?: string | undefined;
}>;
/**
 * Basic expected environment variables for all application
 */
export declare const envVarsBasicConfigSchema: z.ZodObject<{
    NODE_ENV: z.ZodDefault<z.ZodString>;
    sentry_enabled: z.ZodEffects<z.ZodOptional<z.ZodString>, boolean, string | undefined>;
    sentry_dsn: z.ZodDefault<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    NODE_ENV: string;
    sentry_enabled: boolean;
    sentry_dsn: string;
}, {
    NODE_ENV?: string | undefined;
    sentry_enabled?: string | undefined;
    sentry_dsn?: string | undefined;
}>;
/**
 * Expected environment variables for services
 */
export declare const envVarsServiceConfigSchema: z.ZodObject<{
    PORT: z.ZodDefault<z.ZodEffects<z.ZodEffects<z.ZodString, number, string>, number, string>>;
    MONITORING_PORT: z.ZodDefault<z.ZodEffects<z.ZodEffects<z.ZodString, number, string>, number, string>>;
}, "strip", z.ZodTypeAny, {
    PORT: number;
    MONITORING_PORT: number;
}, {
    PORT?: string | undefined;
    MONITORING_PORT?: string | undefined;
}>;
