"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Auth0AuthenticationClient = void 0;
const auth0_1 = require("auth0");
class Auth0AuthenticationClient {
    constructor({ domain, clientId, clientSecret, connectionName, idTokenSigningAlg, }) {
        this.login = ({ email, password, scope }) => __awaiter(this, void 0, void 0, function* () {
            var _a;
            const response = yield ((_a = this.authenticationClient.oauth) === null || _a === void 0 ? void 0 : _a.passwordGrant(Object.assign({ username: email, password, audience: `https://${this.domain}/api/v2/`, realm: this.connectionName }, (scope && { scope }))));
            return response.data.access_token;
        });
        this.domain = domain;
        this.connectionName = connectionName;
        this.authenticationClient = new auth0_1.AuthenticationClient({
            domain,
            clientId,
            clientSecret,
            idTokenSigningAlg,
        });
    }
}
exports.Auth0AuthenticationClient = Auth0AuthenticationClient;
//# sourceMappingURL=Auth0AuthenticationClient.js.map