"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAmqpConnection = void 0;
const amqp = __importStar(require("amqplib"));
const events_1 = require("events");
const ChannelProvider_1 = __importDefault(require("./ChannelProvider"));
const QueuePublisher_1 = __importDefault(require("./QueuePublisher"));
const QueueSubscriber_1 = __importDefault(require("./QueueSubscriber"));
const debug_1 = __importDefault(require("debug"));
const genericGracefulExit_1 = require("../Events/genericGracefulExit");
const connection_1 = require("../ThirdParty/connection");
const { createPool } = require('generic-pool');
const debug = (0, debug_1.default)('@signageos/lib:AMQP:amqpConnectionFactory');
const defaultOptions = {
    priorityRange: 3,
    min: 1,
    max: 10,
    autostart: false,
    testOnBorrow: true,
    acquireTimeoutMillis: 3e3,
};
const defaultConnectionFactory = (dsn) => amqp.connect(dsn);
function createAmqpConnection(dsn, options = {}, onExit, 
/**
 * Option to provide own factory
 *
 * Especially useful in tests for mocking the connection
 */
connectionFactory = defaultConnectionFactory) {
    const timeout = 30e3;
    const gracefulExit = new genericGracefulExit_1.GenericGracefulExit('rabbitmq', timeout, onExit);
    const emitter = new events_1.EventEmitter();
    const factory = {
        create() {
            return __awaiter(this, void 0, void 0, function* () {
                debug('Create connection');
                try {
                    const connection = yield connectionFactory(dsn);
                    gracefulExit.connected();
                    connection.isClosed = false;
                    connection.on('error', (error) => {
                        debug(error); // exceptions are thrown in promises
                    });
                    connection.on('close', () => {
                        debug('Closed connection');
                        connection.isClosed = true;
                        emitter.emit(connection_1.ThirdPartyConnectionEvent.ConnectionClosed);
                    });
                    emitter.emit(connection_1.ThirdPartyConnectionEvent.ConnectionOpen);
                    return connection;
                }
                catch (e) {
                    debug('Caught error: %O', e);
                    gracefulExit.waitToConnectOrDie();
                }
                return Promise.reject(new Error('Unable to create connection AMQP'));
            });
        },
        destroy(connection) {
            return __awaiter(this, void 0, void 0, function* () {
                debug('Destroy connection');
                if (!connection.isClosed) {
                    yield connection.close();
                    emitter.emit(connection_1.ThirdPartyConnectionEvent.ConnectionClosed);
                }
            });
        },
        validate(connection) {
            return __awaiter(this, void 0, void 0, function* () {
                return !connection.isClosed;
            });
        },
    };
    options = Object.assign(Object.assign({}, defaultOptions), options);
    const pool = createPool(factory, options);
    pool.on('factoryCreateError', (error) => {
        debug('factoryCreateError %o', error);
        throw error;
    });
    pool.on('factoryDestroyError', (error) => {
        debug('factoryDestroyError %o', error);
        throw error;
    });
    const channelProvider = new ChannelProvider_1.default(pool);
    return {
        pool,
        channelProvider,
        queuePublisher: new QueuePublisher_1.default(),
        queueSubscriber: new QueueSubscriber_1.default(),
        connect() {
            return __awaiter(this, void 0, void 0, function* () {
                debug('connect');
                const initialConnection = yield pool.acquire();
                yield pool.release(initialConnection);
            });
        },
        close() {
            return __awaiter(this, void 0, void 0, function* () {
                debug('close');
                yield channelProvider.close();
                yield pool.drain();
                pool.clear();
            });
        },
        addListener(event, listener) {
            emitter.addListener(event, listener);
        },
        removeListener(event, listener) {
            emitter.removeListener(event, listener);
        },
    };
}
exports.createAmqpConnection = createAmqpConnection;
//# sourceMappingURL=amqpConnectionFactory.js.map