"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const QueueRepeatableSubscription_1 = __importDefault(require("./QueueRepeatableSubscription"));
const debug_1 = __importDefault(require("debug"));
const debug = (0, debug_1.default)('@signageos/lib:AMQP:QueueSubscriber');
class QueueSubscriber {
    subscribe(createChannel, queueName, bindings, onMessage, consumeOptions = {}, onEnded) {
        return __awaiter(this, void 0, void 0, function* () {
            const channel = yield createChannel();
            const cancelConsumption = yield channel.consumeSimple(queueName, bindings, onMessage, consumeOptions, onEnded);
            debug('Messages subscribed: %s', queueName, bindings);
            return () => __awaiter(this, void 0, void 0, function* () {
                try {
                    yield cancelConsumption();
                }
                catch (error) {
                    console.error(`Could not cancel consumption in QueueSubscriber:subscribe method`, queueName, error);
                }
                return () => channel.close();
            });
        });
    }
    subscribeRepeatable(createChannel, queueName, bindings, onMessage, consumeOptions = {}) {
        return __awaiter(this, void 0, void 0, function* () {
            const repeatableSubscription = new QueueRepeatableSubscription_1.default((onEnded) => this.subscribe(createChannel, queueName, bindings, onMessage, consumeOptions, onEnded));
            yield repeatableSubscription.subscribe();
            debug('Messages subscribed: %s', queueName, bindings);
            return () => repeatableSubscription.cancel();
        });
    }
    subscribeExpectingConfirmation(createChannel, queueName, bindings, onMessage, consumeOptions = {}, onEnded) {
        return __awaiter(this, void 0, void 0, function* () {
            const channel = yield createChannel();
            const cancelConsumption = yield channel.consume(queueName, bindings, onMessage, consumeOptions, onEnded);
            debug('Messages subscribed expecting confirmation: %s', queueName, bindings);
            return () => __awaiter(this, void 0, void 0, function* () {
                try {
                    yield cancelConsumption();
                }
                catch (error) {
                    console.error(`Could not cancel consumption in QueueSubscriber:subscribeExpectingConfirmation method`, queueName, error);
                }
                return () => channel.close();
            });
        });
    }
    subscribeExpectingConfirmationRepeatable(createChannel, queueName, bindings, onMessage, consumeOptions = {}) {
        return __awaiter(this, void 0, void 0, function* () {
            const repeatableSubscription = new QueueRepeatableSubscription_1.default((onEnded) => this.subscribeExpectingConfirmation(createChannel, queueName, bindings, onMessage, consumeOptions, onEnded));
            yield repeatableSubscription.subscribe();
            debug('Messages subscribed expecting confirmation: %s', queueName, bindings);
            return () => repeatableSubscription.cancel();
        });
    }
}
exports.default = QueueSubscriber;
//# sourceMappingURL=QueueSubscriber.js.map