"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InMemoryEventConsumer = void 0;
const events_1 = require("events");
/**
 * In-memory implementation of IEventConsumer
 *
 * Main use case is for testing so that the tests are not dependent on AMQP or other external services
 */
class InMemoryEventConsumer {
    constructor() {
        this.emitter = new events_1.EventEmitter();
    }
    addEventConsumer(eventType, callback) {
        return __awaiter(this, void 0, void 0, function* () {
            this.emitter.addListener(eventType, callback);
        });
    }
    /**
     * Will deliver the event to all consumers that were added via addEventConsumer
     */
    emitEvent(event) {
        this.emitter.emit(event.type, event);
    }
}
exports.InMemoryEventConsumer = InMemoryEventConsumer;
//# sourceMappingURL=InMemoryEventConsumer.js.map