"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.prepareAll = exports.deleteAll = exports.purgeAll = exports.fetchNextAutoSnapshot = exports.fetchNext = exports.bindAutoSnapshots = exports.bindAll = exports.process = exports.enqueue = exports.AUTO_SNAPSHOTS_QUEUE_NAME = exports.QUEUE_NAME = void 0;
const fetchNextMessage_1 = __importDefault(require("../fetchNextMessage"));
exports.QUEUE_NAME = 'commands';
exports.AUTO_SNAPSHOTS_QUEUE_NAME = 'auto_snapshots';
const DEFAULT_OPTIONS = {
    persistent: true,
    confirmable: false,
    maxPriority: 10,
};
function enqueue(amqpConnection, command, messageOptions = { priority: 5 }) {
    return __awaiter(this, void 0, void 0, function* () {
        const createChannel = () => __awaiter(this, void 0, void 0, function* () {
            const channel = yield amqpConnection.channelProvider.getChannel(exports.QUEUE_NAME, DEFAULT_OPTIONS);
            yield channel.assertExchange(exports.QUEUE_NAME, 'topic');
            return channel;
        });
        yield amqpConnection.queuePublisher.enqueue(createChannel, command, undefined, exports.QUEUE_NAME, exports.QUEUE_NAME, messageOptions);
    });
}
exports.enqueue = enqueue;
function process(amqpConnection, command, messageOptions = { priority: 6 }) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield amqpConnection.queuePublisher.enqueueExpectingResponse(() => __awaiter(this, void 0, void 0, function* () {
            const channel = yield amqpConnection.channelProvider.getChannel(exports.QUEUE_NAME, DEFAULT_OPTIONS);
            yield channel.assertExchange(exports.QUEUE_NAME, 'topic');
            return channel;
        }), command, undefined, exports.QUEUE_NAME, exports.QUEUE_NAME, messageOptions);
    });
}
exports.process = process;
function bindAll(amqpConnection, options, onCommand) {
    return __awaiter(this, void 0, void 0, function* () {
        const fullOptions = Object.assign(Object.assign({}, DEFAULT_OPTIONS), options);
        return yield amqpConnection.queueSubscriber.subscribeExpectingConfirmationRepeatable(() => __awaiter(this, void 0, void 0, function* () {
            const channel = yield amqpConnection.channelProvider.getChannel(exports.QUEUE_NAME, fullOptions);
            yield channel.assertExchange(exports.QUEUE_NAME, 'topic');
            return channel;
        }), exports.QUEUE_NAME, [{ exchangeName: exports.QUEUE_NAME, routingKey: exports.QUEUE_NAME, persistent: true }], (command, _headers, ack, nack) => __awaiter(this, void 0, void 0, function* () {
            try {
                const response = yield onCommand(command);
                ack();
                return response;
            }
            catch (error) {
                nack();
                throw error;
            }
        }), { autoDelete: false, respond: true });
    });
}
exports.bindAll = bindAll;
function bindAutoSnapshots(amqpConnection, options, onCommand) {
    return __awaiter(this, void 0, void 0, function* () {
        const fullOptions = Object.assign(Object.assign({}, DEFAULT_OPTIONS), options);
        return yield amqpConnection.queueSubscriber.subscribeExpectingConfirmationRepeatable(() => __awaiter(this, void 0, void 0, function* () {
            const channel = yield amqpConnection.channelProvider.getChannel(exports.AUTO_SNAPSHOTS_QUEUE_NAME, fullOptions);
            yield channel.assertExchange(exports.QUEUE_NAME, 'topic');
            return channel;
        }), exports.AUTO_SNAPSHOTS_QUEUE_NAME, [{ exchangeName: exports.QUEUE_NAME, routingKey: exports.QUEUE_NAME, persistent: true }], (command, _headers, ack, nack) => __awaiter(this, void 0, void 0, function* () {
            try {
                yield onCommand(command);
                ack();
            }
            catch (error) {
                nack();
                throw error;
            }
        }), { autoDelete: false, durable: false, respond: false });
    });
}
exports.bindAutoSnapshots = bindAutoSnapshots;
function fetchNext(amqpConnection) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield (0, fetchNextMessage_1.default)(amqpConnection, exports.QUEUE_NAME, exports.QUEUE_NAME, exports.QUEUE_NAME, undefined, {
            maxPriority: DEFAULT_OPTIONS.maxPriority,
        });
    });
}
exports.fetchNext = fetchNext;
function fetchNextAutoSnapshot(amqpConnection) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield (0, fetchNextMessage_1.default)(amqpConnection, exports.AUTO_SNAPSHOTS_QUEUE_NAME, exports.QUEUE_NAME, exports.QUEUE_NAME, undefined, {
            maxPriority: DEFAULT_OPTIONS.maxPriority,
            durable: false,
        });
    });
}
exports.fetchNextAutoSnapshot = fetchNextAutoSnapshot;
function purgeAll(amqpConnection) {
    return __awaiter(this, void 0, void 0, function* () {
        const channel = yield amqpConnection.channelProvider.getChannel(exports.QUEUE_NAME);
        try {
            yield channel.purge(exports.QUEUE_NAME);
            yield channel.purge(exports.AUTO_SNAPSHOTS_QUEUE_NAME);
        }
        finally {
            yield channel.close();
        }
    });
}
exports.purgeAll = purgeAll;
function deleteAll(amqpConnection) {
    return __awaiter(this, void 0, void 0, function* () {
        const channel = yield amqpConnection.channelProvider.getChannel(exports.QUEUE_NAME);
        try {
            yield channel.delete(exports.QUEUE_NAME);
            yield channel.delete(exports.AUTO_SNAPSHOTS_QUEUE_NAME);
        }
        finally {
            yield channel.close();
        }
    });
}
exports.deleteAll = deleteAll;
function prepareAll(amqpConnection) {
    return __awaiter(this, void 0, void 0, function* () {
        // Hack to create event queue for exchange
        yield fetchNext(amqpConnection);
        yield fetchNextAutoSnapshot(amqpConnection);
    });
}
exports.prepareAll = prepareAll;
//# sourceMappingURL=commandQueue.js.map