"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createWsSocketServer = void 0;
var isomorphic_ws_1 = __importDefault(require("isomorphic-ws"));
var events_1 = require("events");
var generator_1 = require("../Hash/generator");
var debug_1 = __importDefault(require("debug"));
var http_1 = require("../Utils/http");
var debug = (0, debug_1.default)('@signageos/lib:WebSocket:wsServerFactory');
var CloseCode;
(function (CloseCode) {
    CloseCode[CloseCode["NO_PONG"] = 3000] = "NO_PONG";
    CloseCode[CloseCode["PING_FAILED"] = 3001] = "PING_FAILED";
    CloseCode[CloseCode["FORCE_DISCONNECT"] = 3002] = "FORCE_DISCONNECT";
})(CloseCode || (CloseCode = {}));
function createWsSocketServer(httpServer, options) {
    if (options === void 0) { options = {}; }
    var serverClosed = false;
    var wss = new isomorphic_ws_1.default.Server({
        server: httpServer,
        path: options.path,
    });
    var wsMap = {};
    var interval = setInterval(function () {
        Object.keys(wsMap).forEach(function (wsUid) {
            if (!wsMap[wsUid].isAlive) {
                wsMap[wsUid].safeTerminate(CloseCode.NO_PONG, "Didn't receive pong");
            }
            else {
                wsMap[wsUid].isAlive = false;
                try {
                    wsMap[wsUid].ws.ping();
                }
                catch (error) {
                    wsMap[wsUid].safeTerminate(CloseCode.PING_FAILED, 'Ping error');
                }
            }
        });
    }, 30e3);
    return {
        server: {
            bindConnection: function (serverListener) {
                wss.on('error', function (error) { return console.error(error); });
                wss.on('connection', function (ws, req) {
                    debug('connection', { headers: req.headers });
                    var closedPromise;
                    var wsUid = (0, generator_1.generateUniqueHash)();
                    var socketHostname = (0, http_1.getHostnameFromRequestHeaders)(req.headers);
                    function safeTerminate(code, reason) {
                        debug('Safe terminate', wsMap[wsUid]);
                        ws.terminate();
                        if (typeof wsMap[wsUid] !== 'undefined') {
                            ws.emit('close', code, reason);
                        }
                    }
                    wsMap[wsUid] = {
                        ws: ws,
                        isAlive: true,
                        safeTerminate: safeTerminate,
                    };
                    ws.on('pong', function () {
                        debug('pong');
                        wsMap[wsUid].isAlive = true;
                    });
                    ws.once('close', function () {
                        debug('close');
                        closedPromise = Promise.resolve();
                        delete wsMap[wsUid];
                    });
                    var messageEmitter = new events_1.EventEmitter();
                    var responseEmitter = new events_1.EventEmitter();
                    ws.on('message', function (messageData) {
                        debug('message', messageData);
                        var message = JSON.parse(messageData);
                        switch (message.type) {
                            case 'response':
                                responseEmitter.emit(message.responseUid);
                                break;
                            case 'request':
                                messageEmitter.emit(message.event, message.payload);
                                if (message.responseUid) {
                                    var responseMessage = {
                                        type: 'response',
                                        responseUid: message.responseUid,
                                    };
                                    try {
                                        ws.send(JSON.stringify(responseMessage));
                                    }
                                    catch (error) {
                                        debug('Cannot send response back', message, error);
                                    }
                                }
                                break;
                            case 'ping':
                                try {
                                    var pongMessage = { type: 'pong' };
                                    ws.send(JSON.stringify(pongMessage));
                                }
                                catch (error) {
                                    debug('Cannot send pong', error);
                                }
                                break;
                            default:
                        }
                    });
                    ws.on('error', function (error) { return console.error(error); });
                    serverListener({
                        getDisconnectedPromise: function () {
                            return new Promise(function (resolve) {
                                ws.once('close', function (code, reason) { return resolve({ code: code, reason: reason }); });
                            });
                        },
                        bindError: function (listener) {
                            ws.on('error', listener);
                            return function () { return ws.removeListener('error', listener); };
                        },
                        bindMessage: function (event, listener) {
                            messageEmitter.on(event, listener);
                            return function () { return messageEmitter.removeListener(event, listener); };
                        },
                        getMessagePromise: function (event) {
                            return new Promise(function (resolve) {
                                messageEmitter.once(event, resolve);
                            });
                        },
                        sendMessage: function (event, payload) {
                            var message = {
                                type: 'request',
                                event: event,
                                payload: payload,
                            };
                            return new Promise(function (resolve, reject) {
                                try {
                                    ws.send(JSON.stringify(message), function (error) { return (error ? reject(error) : resolve()); });
                                }
                                catch (error) {
                                    reject(error);
                                }
                            });
                        },
                        sendMessageExpectingResponse: function (event, payload) {
                            return __awaiter(this, void 0, void 0, function () {
                                var responseUid, message, responsePromise, sendPromise;
                                return __generator(this, function (_a) {
                                    switch (_a.label) {
                                        case 0:
                                            responseUid = (0, generator_1.generateUniqueHash)();
                                            message = {
                                                type: 'request',
                                                event: event,
                                                payload: payload,
                                                responseUid: responseUid,
                                            };
                                            responsePromise = new Promise(function (resolve) {
                                                responseEmitter.once(responseUid, function () { return resolve(); });
                                            });
                                            sendPromise = new Promise(function (resolve, reject) {
                                                try {
                                                    ws.send(JSON.stringify(message), function (error) { return (error ? reject(error) : resolve()); });
                                                }
                                                catch (error) {
                                                    reject(error);
                                                }
                                            });
                                            return [4 /*yield*/, Promise.all([sendPromise, responsePromise])];
                                        case 1:
                                            _a.sent();
                                            return [2 /*return*/];
                                    }
                                });
                            });
                        },
                        disconnect: function (code, reason) {
                            if (typeof closedPromise !== 'undefined') {
                                return closedPromise;
                            }
                            closedPromise = new Promise(function (resolve) {
                                var terminateTimeout = setTimeout(function () {
                                    safeTerminate(CloseCode.FORCE_DISCONNECT, 'Force disconnect');
                                    resolve();
                                }, 30e3);
                                ws.once('close', function () {
                                    clearTimeout(terminateTimeout);
                                    resolve();
                                });
                            });
                            ws.close(code, reason);
                            return closedPromise;
                        },
                        drain: function () {
                            ws.removeAllListeners();
                            messageEmitter.removeAllListeners();
                            responseEmitter.removeAllListeners();
                        },
                        hostname: socketHostname,
                        path: req.url,
                        headers: req.headers,
                    });
                });
            },
        },
        listen: function () {
            return __awaiter(this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    debug('Automatically started');
                    return [2 /*return*/];
                });
            });
        },
        close: function () {
            return __awaiter(this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            if (serverClosed) {
                                throw new Error('Server was already closed');
                            }
                            serverClosed = true;
                            clearInterval(interval);
                            return [4 /*yield*/, new Promise(function (resolve) {
                                    wss.close(resolve);
                                })];
                        case 1:
                            _a.sent();
                            return [2 /*return*/];
                    }
                });
            });
        },
    };
}
exports.createWsSocketServer = createWsSocketServer;
//# sourceMappingURL=wsServerFactory.js.map