"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mapObject = exports.convertObjectUndefinedPropertiesToNull = exports.getObjectKeys = exports.getObjectWithOmittedValuesBy = void 0;
var lodash_1 = require("lodash");
var isObject = function (value) { return !(0, lodash_1.isString)(value) && !(0, lodash_1.isEmpty)(value); };
var isTypeOf = function (value, comparedValue) {
    if ((0, lodash_1.isUndefined)(value) && (0, lodash_1.isUndefined)(comparedValue)) {
        return true;
    }
    if ((0, lodash_1.isNull)(value) && (0, lodash_1.isNull)(comparedValue)) {
        return true;
    }
    if ((0, lodash_1.isNumber)(value) && (0, lodash_1.isNumber)(comparedValue) && value === comparedValue) {
        return true;
    }
    if ((0, lodash_1.isString)(value) && (0, lodash_1.isString)(comparedValue) && value === comparedValue) {
        return true;
    }
    if ((0, lodash_1.isDate)(value) && (0, lodash_1.isDate)(comparedValue) && value === comparedValue) {
        return true;
    }
    return false;
};
var getOmittedArray = function (array, omittedValue) {
    var iteratedValues = [];
    for (var _i = 0, array_1 = array; _i < array_1.length; _i++) {
        var item = array_1[_i];
        if (isTypeOf(item, omittedValue)) {
            continue;
        }
        else if (isObject(item)) {
            iteratedValues.push(__assign({}, (0, exports.getObjectWithOmittedValuesBy)(item, omittedValue)));
            continue;
        }
        else {
            iteratedValues.push(item);
            continue;
        }
    }
    return iteratedValues;
};
/**
 * @param input can be any object
 * @param omittedValue value which should be omitted, currently supports `undefined`,
 *  `null`, `exact number`, `exact string` and `exact date`
 * @returns the same object recursively but without fields with omitted value
 */
var getObjectWithOmittedValuesBy = function (input, omittedValue) {
    var _a, _b, _c;
    var result = {};
    for (var key in input) {
        var value = input[key];
        // Validates omitted value
        if (isTypeOf(value, omittedValue)) {
            continue;
        }
        else if ((0, lodash_1.isArray)(value)) {
            result = __assign(__assign({}, result), (_a = {}, _a[key] = getOmittedArray(value, omittedValue), _a));
            continue;
        }
        else if (isObject(value)) {
            result = __assign(__assign({}, result), (_b = {}, _b[key] = __assign({}, (0, exports.getObjectWithOmittedValuesBy)(value, omittedValue)), _b));
            continue;
        }
        result = __assign(__assign({}, result), (_c = {}, _c[key] = value, _c));
    }
    return result;
};
exports.getObjectWithOmittedValuesBy = getObjectWithOmittedValuesBy;
/**
 * Better typed version of Object.keys function returning Array of keyof types instead of Array of string types.
 */
exports.getObjectKeys = Object.keys;
function convertObjectUndefinedPropertiesToNull(obj) {
    var result = {};
    for (var key in obj) {
        var value = obj[key];
        if (value === undefined) {
            result[key] = null;
        }
        else {
            result[key] = value;
        }
    }
    return result;
}
exports.convertObjectUndefinedPropertiesToNull = convertObjectUndefinedPropertiesToNull;
function mapObject(settings, transform) {
    var timerSettings = {};
    for (var _i = 0, _a = (0, exports.getObjectKeys)(settings); _i < _a.length; _i++) {
        var timerType = _a[_i];
        timerSettings[timerType] = transform(settings[timerType]);
    }
    return timerSettings;
}
exports.mapObject = mapObject;
//# sourceMappingURL=object.js.map