"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.castEnum = exports.getEnumFromString = void 0;
/**
 * @param e string enum from which to retrieve the value
 * @param value string which should be converted to enum value
 * @returns enum value or undefined if value is not in enum
 * @throws error if enum is numeric or heterogeneous
 */
function getEnumFromString(e, value) {
    var allValues = Object.values(e);
    var numericValues = Object.values(e).filter(function (v) { return !isNaN(Number(v)); });
    if (numericValues.length > 0) {
        throw Error('Enum has non-string values');
    }
    return allValues.includes(value) ? value : undefined;
}
exports.getEnumFromString = getEnumFromString;
/**
 * Safely casts `val` of enum type `U` to enum of type `T`, only if enums
 * overlap. This is only compile-time cast and it does not validate the value
 * during runtime.
 *
 * **`castEnum` only works for enums with string values**
 *
 * @example
 * enum AB { a = "A", b = "B" }
 * enum ABC { A = "A", B = "B", C = "C" }
 *
 * const x: AB = castEnum(ABC.B) // does work
 * const x: AB = castEnum(ABC.C) // does not work
 */
var castEnum = function (val) { return val; };
exports.castEnum = castEnum;
//# sourceMappingURL=enum.js.map