"use strict";
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLastTimerEvent = exports.getNextTimerEvent = exports.getNextTimerEventForFollowingDays = exports.getNextTimerEventForSameDay = exports.getTimerEvents = exports.getTimerEventsFromShortWeekday = exports.orderTimerEventsByChronology = exports.shouldBeOnByTimerSettings = exports.shouldBeOnByTimers = void 0;
var moment_timezone_1 = __importDefault(require("moment-timezone"));
var converters_1 = require("../converters");
var timeConverter_1 = require("../../DateTime/timeConverter");
var object_1 = require("../../Utils/object");
var TimerEventWeekdayNumber_1 = require("./TimerEventWeekdayNumber");
/**
 * @deprecated use `getLastTimerEvent` and `convertLegacyTimerToShortWeekdayTimer` instead
 */
function shouldBeOnByTimers(timerSettings, now) {
    return shouldBeOnByTimerSettings((0, converters_1.convertLegacyTimerToShortWeekdayTimer)(timerSettings), now);
}
exports.shouldBeOnByTimers = shouldBeOnByTimers;
/**
 * @deprecated use `getLastTimerEvent` instead
 */
function shouldBeOnByTimerSettings(timerSettings, now) {
    var lastTimerEvent = getLastTimerEvent(timerSettings, now);
    return lastTimerEvent === null ? null : lastTimerEvent.type === 'ON';
}
exports.shouldBeOnByTimerSettings = shouldBeOnByTimerSettings;
function orderTimerEventsByChronology(timerEvents) {
    return timerEvents.sort(function (a, b) {
        return (a.weekDayNumber - b.weekDayNumber) * (24 * 60 * 60) + // whole day in seconds
            (0, timeConverter_1.timeToSeconds)(a.time) -
            (0, timeConverter_1.timeToSeconds)(b.time);
    });
}
exports.orderTimerEventsByChronology = orderTimerEventsByChronology;
function getTimerEventsFromShortWeekday(allSettings) {
    var timerEvents = [];
    for (var _i = 0, _a = (0, object_1.getObjectKeys)(allSettings); _i < _a.length; _i++) {
        var type = _a[_i];
        var settings = allSettings[type];
        for (var _b = 0, _c = settings.weekdays; _b < _c.length; _b++) {
            var weekday = _c[_b];
            if (settings.timeOn) {
                timerEvents.push({
                    weekDayNumber: TimerEventWeekdayNumber_1.TimerEventWeekdayNumber[weekday],
                    type: 'ON',
                    time: settings.timeOn,
                    timerType: settings.type,
                });
            }
            if (settings.timeOff) {
                timerEvents.push({
                    weekDayNumber: TimerEventWeekdayNumber_1.TimerEventWeekdayNumber[weekday],
                    type: 'OFF',
                    time: settings.timeOff,
                    timerType: settings.type,
                });
            }
        }
    }
    return timerEvents;
}
exports.getTimerEventsFromShortWeekday = getTimerEventsFromShortWeekday;
function getTimerEvents(allSettings) {
    return getTimerEventsFromShortWeekday((0, converters_1.convertLegacyTimerToShortWeekdayTimer)(allSettings));
}
exports.getTimerEvents = getTimerEvents;
function getNextTimerEventForSameDay(sortedTimerEvents, now) {
    return sortedTimerEvents.find(function (timerEvent) {
        var isThisDay = timerEvent.weekDayNumber === now.getDay();
        var isOnTime = (0, timeConverter_1.timeToSeconds)(timerEvent.time) >= (0, timeConverter_1.timeToSeconds)((0, moment_timezone_1.default)(now).tz('UTC', false).format('HH:mm:ss'));
        return isThisDay && isOnTime;
    });
}
exports.getNextTimerEventForSameDay = getNextTimerEventForSameDay;
function getNextTimerEventForFollowingDays(sortedTimerEvents, now) {
    return sortedTimerEvents.find(function (timerEvent) {
        return timerEvent.weekDayNumber > now.getDay();
    });
}
exports.getNextTimerEventForFollowingDays = getNextTimerEventForFollowingDays;
function getNextTimerEvent(allSettings, now, timerType) {
    var timerEvents = getTimerEventsFromShortWeekday(allSettings);
    // if there is no timer event at all, return null
    if (timerEvents.length === 0) {
        return null;
    }
    var sortedTimerEvents = orderTimerEventsByChronology(timerEvents);
    var filteredSortedTimerEvents = sortedTimerEvents.filter(function (timerEvent) {
        return timerEvent.type === timerType;
    });
    // if there is no timer event for the desired timerType, return null
    if (!filteredSortedTimerEvents.length) {
        return null;
    }
    // then we try to find the next timer event on the same day
    var sameDayNextTimerEvent = getNextTimerEventForSameDay(filteredSortedTimerEvents, now);
    if (sameDayNextTimerEvent) {
        return sameDayNextTimerEvent;
    }
    // if there is no timer event on the same day, we are looking for the next timer event
    // for the remaining days of this week
    var followingDaysNextTimerEvent = getNextTimerEventForFollowingDays(filteredSortedTimerEvents, now);
    if (followingDaysNextTimerEvent) {
        return followingDaysNextTimerEvent;
    }
    // above we ensured that:
    // - there is at least one timer event satisfying the desired timerType
    // - there is no timer event for the same day
    // - there is no timer event for the remaining days of this week
    // - therefore, the next expected timer event must be scheduled for the next week
    // expected timers were previously sorted, so we can return the first one
    return filteredSortedTimerEvents[0];
}
exports.getNextTimerEvent = getNextTimerEvent;
function getLastTimerEvent(allSettings, now, timerType) {
    var timerEvents = getTimerEventsFromShortWeekday(allSettings);
    if (timerEvents.length === 0) {
        return null;
    }
    var sortedTimerEvents = orderTimerEventsByChronology(timerEvents);
    var lastTimerEvent = __spreadArray([], sortedTimerEvents, true).reverse().find(function (timerEvent) {
        if (timerType && timerEvent.type !== timerType) {
            return false;
        }
        var inNextDay = timerEvent.weekDayNumber < now.getDay();
        var isThisDay = timerEvent.weekDayNumber === now.getDay();
        var isOnTime = (0, timeConverter_1.timeToSeconds)(timerEvent.time) <= (0, timeConverter_1.timeToSeconds)((0, moment_timezone_1.default)(now).format('HH:mm:ss'));
        return inNextDay || (isThisDay && isOnTime);
    });
    return lastTimerEvent ? lastTimerEvent : __spreadArray([], sortedTimerEvents, true).reverse()[0];
}
exports.getLastTimerEvent = getLastTimerEvent;
//# sourceMappingURL=powerTimerComputer.js.map