export declare enum ThirdPartyConnectionEvent {
    ConnectionOpen = "connection_open",
    ConnectionClosed = "connection_closed"
}
/**
 * @deprecated
 * This interface was originally meant as abstraction to easier export third party connections to metrics.
 * Now, instead, the remaining connections that implement this interface should be rewritten to export metrics directly,
 * similarly to how MongoDBConnection does it.
 * This interface will be removed in the future.
 */
export interface IThirdPartyConnection {
    connect: () => Promise<void>;
    close: () => Promise<void>;
    addListener: (event: ThirdPartyConnectionEvent, listener: () => void) => void;
    removeListener: (event: ThirdPartyConnectionEvent, listener: () => void) => void;
}
