"use strict";
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.routeStatus = void 0;
var createHttpStatusMiddleware_1 = __importDefault(require("../../../../HttpStatus/createHttpStatusMiddleware"));
var amqpStatus_1 = require("../../../../HttpStatus/statuses/amqpStatus");
var postgreStatus_1 = require("../../../../HttpStatus/statuses/postgreStatus");
var redisStatus_1 = require("../../../../HttpStatus/statuses/redisStatus");
var mongoStatus_1 = require("../../../../HttpStatus/statuses/mongoStatus");
/**
 * Serves some basic human-readable information about the service
 */
function routeStatus(_a) {
    var router = _a.router, service = _a.service, connections = _a.connections;
    var statuses = [];
    if (connections === null || connections === void 0 ? void 0 : connections.amqp) {
        var amqpConnections = Object.values(connections.amqp);
        statuses.push((0, amqpStatus_1.amqpStatus)(amqpConnections, service.uid));
    }
    if (connections === null || connections === void 0 ? void 0 : connections.postgres) {
        var postgresConnections = Object.values(connections.postgres);
        statuses.push((0, postgreStatus_1.postgreStatus)(postgresConnections, service.uid));
    }
    if (connections === null || connections === void 0 ? void 0 : connections.redis) {
        var redisConnections = Object.values(connections.redis);
        statuses.push((0, redisStatus_1.redisStatus)(redisConnections, service.uid));
    }
    if (connections === null || connections === void 0 ? void 0 : connections.mongodb) {
        var mongodbConnections = Object.values(connections.mongodb);
        statuses.push((0, mongoStatus_1.mongoStatus)(mongodbConnections, service.uid));
    }
    router.get('/status', createHttpStatusMiddleware_1.default.apply(void 0, __spreadArray([{
            namespace: service.name,
            uniqueId: service.uid,
            // TODO expose from library
            // additionalDataCallback: (_req: Request) => {
            // },
        }], statuses, false)));
}
exports.routeStatus = routeStatus;
//# sourceMappingURL=status.js.map