"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.numerize = exports.normalizeString = exports.normalize = exports.isGreaterThan = exports.sortFunction = exports.getUpgradedVersion = void 0;
var pad_1 = require("../String/pad");
var semver = __importStar(require("semver"));
function getUpgradedVersion(version, level) {
    var versionParts = version.split('.');
    versionParts[2 - level] = (parseInt(versionParts[2 - level]) + 1).toString();
    for (var index = versionParts.length - 1; index > 2 - level; index--) {
        versionParts[index] = '0';
    }
    return versionParts.join('.');
}
exports.getUpgradedVersion = getUpgradedVersion;
function sortFunction(a, b) {
    return semver.compare(normalize(a), normalize(b));
}
exports.sortFunction = sortFunction;
function isGreaterThan(subject, compareWith) {
    return sortFunction(subject, compareWith) > 0;
}
exports.isGreaterThan = isGreaterThan;
function normalize(version) {
    var _a = version.toString().split('-'), mainVersion = _a[0], restVersionParts = _a.slice(1);
    var versionParts = mainVersion.split('.');
    do {
        if (versionParts.length > 3) {
            versionParts.pop();
        }
        else if (versionParts.length < 3) {
            versionParts.unshift('0');
        }
    } while (versionParts.length !== 3);
    for (var index in versionParts) {
        versionParts[index] = isNaN(parseInt(versionParts[index])) ? '0' : parseInt(versionParts[index]).toString();
    }
    return __spreadArray([versionParts.join('.')], restVersionParts, true).join('-');
}
exports.normalize = normalize;
function normalizeString(version) {
    return (0, pad_1.padLeft)(numerize(version).toString(), 5 * 3, '0');
}
exports.normalizeString = normalizeString;
function numerize(version) {
    var versionParts = version.split('.');
    return versionParts.reduce(function (numerized, versionPart, index) {
        return numerized + parseInt(versionPart) * Math.pow(1e5, versionParts.length - index - 1);
    }, 0);
}
exports.numerize = numerize;
//# sourceMappingURL=semVerHelper.js.map