"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.retryAsyncUntil = exports.PredicateNotMetError = exports.retryAsync = void 0;
var progressiveWait_1 = require("../Timer/progressiveWait");
/**
 * Repeatedly try to call the callback function until it successfully resolves
 * or the number of attempts reaches the passed count of attempts.
 * Throws an error otherwise.
 */
var retryAsync = function (count, callback, progressiveWait) {
    if (progressiveWait === void 0) { progressiveWait = (0, progressiveWait_1.createProgressiveWait)(500); }
    return __awaiter(void 0, void 0, void 0, function () {
        var e_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _a.trys.push([0, 2, , 5]);
                    return [4 /*yield*/, callback()];
                case 1: return [2 /*return*/, _a.sent()];
                case 2:
                    e_1 = _a.sent();
                    if (count === 1) {
                        throw e_1;
                    }
                    return [4 /*yield*/, progressiveWait.wait()];
                case 3:
                    _a.sent();
                    return [4 /*yield*/, (0, exports.retryAsync)(--count, callback, progressiveWait)];
                case 4: return [2 /*return*/, _a.sent()];
                case 5: return [2 /*return*/];
            }
        });
    });
};
exports.retryAsync = retryAsync;
var PredicateNotMetError = /** @class */ (function (_super) {
    __extends(PredicateNotMetError, _super);
    function PredicateNotMetError(message) {
        var _this = _super.call(this, message) || this;
        Object.setPrototypeOf(_this, PredicateNotMetError.prototype);
        return _this;
    }
    return PredicateNotMetError;
}(Error));
exports.PredicateNotMetError = PredicateNotMetError;
/**
 * Repeatedly try to call the callback function until the passed predicate function returns true
 * or the number of attempts reaches the passed count of attempts.
 * Throws an error otherwise.
 */
var retryAsyncUntil = function (_a) {
    var callback = _a.callback, predicate = _a.predicate, _b = _a.progressiveWait, progressiveWait = _b === void 0 ? (0, progressiveWait_1.createProgressiveWait)(500) : _b, _c = _a.count, count = _c === void 0 ? 10 : _c, attemptErrorLog = _a.attemptErrorLog;
    return __awaiter(void 0, void 0, void 0, function () {
        var payload, e_2;
        return __generator(this, function (_d) {
            switch (_d.label) {
                case 0:
                    _d.trys.push([0, 4, , 7]);
                    if (count === 0) {
                        throw new PredicateNotMetError("Predicate not met after specified number of attempts.");
                    }
                    return [4 /*yield*/, callback()];
                case 1:
                    payload = _d.sent();
                    if (predicate(payload)) {
                        return [2 /*return*/, payload];
                    }
                    return [4 /*yield*/, progressiveWait.wait()];
                case 2:
                    _d.sent();
                    return [4 /*yield*/, (0, exports.retryAsyncUntil)({ callback: callback, predicate: predicate, progressiveWait: progressiveWait, count: --count, attemptErrorLog: attemptErrorLog })];
                case 3: return [2 /*return*/, _d.sent()];
                case 4:
                    e_2 = _d.sent();
                    if (attemptErrorLog !== undefined && e_2 instanceof Error) {
                        attemptErrorLog(e_2);
                    }
                    if (e_2 instanceof PredicateNotMetError) {
                        throw e_2;
                    }
                    return [4 /*yield*/, progressiveWait.wait()];
                case 5:
                    _d.sent();
                    return [4 /*yield*/, (0, exports.retryAsyncUntil)({ callback: callback, predicate: predicate, progressiveWait: progressiveWait, count: --count, attemptErrorLog: attemptErrorLog })];
                case 6: return [2 /*return*/, _d.sent()];
                case 7: return [2 /*return*/];
            }
        });
    });
};
exports.retryAsyncUntil = retryAsyncUntil;
//# sourceMappingURL=retry.js.map