"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useRavenLogging = void 0;
var Raven = __importStar(require("raven"));
function useRavenLogging() {
    // override default console logging
    var consoleWarn = console.warn;
    var consoleError = console.error;
    console.warn = function (message) {
        var optionalParams = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            optionalParams[_i - 1] = arguments[_i];
        }
        consoleWarn.call.apply(consoleWarn, __spreadArray([console, message], optionalParams, false));
        if (typeof message !== 'string' || !message.startsWith('raven')) {
            captureRaven.apply(void 0, __spreadArray(['warning', 'warn', message], optionalParams, false));
        }
    };
    console.error = function (message) {
        var optionalParams = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            optionalParams[_i - 1] = arguments[_i];
        }
        consoleError.call.apply(consoleError, __spreadArray([console, message], optionalParams, false));
        if (typeof message !== 'string' || !message.startsWith('raven')) {
            captureRaven.apply(void 0, __spreadArray(['error', 'error', message], optionalParams, false));
        }
    };
}
exports.useRavenLogging = useRavenLogging;
function captureRaven(level, source, message) {
    var optionalParams = [];
    for (var _i = 3; _i < arguments.length; _i++) {
        optionalParams[_i - 3] = arguments[_i];
    }
    var options = {
        level: level,
        tags: {
            source: source,
        },
        extra: optionalParams,
    };
    if (message instanceof Error) {
        Raven.captureException(message, options);
    }
    else {
        if (typeof message === 'string') {
            message = message;
        }
        else {
            message = JSON.stringify(message);
        }
        Raven.captureMessage(message, options);
    }
}
//# sourceMappingURL=raven.js.map