"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsS3 = void 0;
var fs_1 = require("fs");
var client_s3_1 = require("@aws-sdk/client-s3");
var fs_extra_1 = require("fs-extra");
var debugDecorator_1 = require("../Debug/debugDecorator");
var config_1 = require("./config");
var DEBUG_NAMESPACE = '@signageos/lib:AWS:S3';
/**
 * Wrapper for AWS S3 client
 *
 * All commonly used operations with S3 will be implemented here to provide a consistent interface across the codebase.
 */
var AwsS3 = /** @class */ (function () {
    /**
     * @param config.forcePathStyle - Whether to use path style URLs for S3 requests.
     * Defaults to the value of the `AWS_S3_FORCE_PATH_STYLE_URLS` environment variable or false if not set.
     */
    function AwsS3(config) {
        if (config === void 0) { config = {}; }
        config = (0, config_1.getUpdatedS3ClientConfigWithCustomEnvVars)(config);
        this.client = new client_s3_1.S3Client(config);
    }
    AwsS3.prototype.uploadFile = function (_a) {
        var filePath = _a.filePath, bucket = _a.bucket, remotePath = _a.remotePath, contentType = _a.contentType;
        return __awaiter(this, void 0, void 0, function () {
            var fileStream, command;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        fileStream = (0, fs_1.createReadStream)(filePath);
                        command = new client_s3_1.PutObjectCommand({
                            Bucket: bucket,
                            Key: remotePath,
                            Body: fileStream,
                            ContentType: contentType,
                        });
                        return [4 /*yield*/, this.client.send(command)];
                    case 1:
                        _b.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    AwsS3.prototype.uploadContent = function (_a) {
        var content = _a.content, bucket = _a.bucket, remotePath = _a.remotePath, contentType = _a.contentType;
        return __awaiter(this, void 0, void 0, function () {
            var command;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        command = new client_s3_1.PutObjectCommand({
                            Bucket: bucket,
                            Key: remotePath,
                            Body: content,
                            ContentType: contentType,
                        });
                        return [4 /*yield*/, this.client.send(command)];
                    case 1:
                        _b.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    AwsS3.prototype.downloadFile = function (_a) {
        var bucket = _a.bucket, remotePath = _a.remotePath, filePath = _a.filePath;
        return __awaiter(this, void 0, void 0, function () {
            var command, body, response, nodejsWriteStream;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        command = new client_s3_1.GetObjectCommand({
                            Bucket: bucket,
                            Key: remotePath,
                        });
                        return [4 /*yield*/, this.client.send(command)];
                    case 1:
                        body = (_b.sent()).Body;
                        if (body === undefined) {
                            throw new Error('Body is undefined');
                        }
                        response = body;
                        nodejsWriteStream = (0, fs_extra_1.createWriteStream)(filePath);
                        response.pipe(nodejsWriteStream);
                        return [4 /*yield*/, new Promise(function (resolve, reject) {
                                nodejsWriteStream.on('finish', resolve);
                                nodejsWriteStream.on('error', reject);
                            })];
                    case 2:
                        _b.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    AwsS3.prototype.listFiles = function (_a) {
        var bucket = _a.bucket, remotePath = _a.remotePath;
        return __awaiter(this, void 0, void 0, function () {
            var command, contents;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        command = new client_s3_1.ListObjectsV2Command({
                            Bucket: bucket,
                            Prefix: remotePath.endsWith('/') ? remotePath : remotePath + '/',
                        });
                        return [4 /*yield*/, this.client.send(command)];
                    case 1:
                        contents = (_b.sent()).Contents;
                        if (contents === undefined) {
                            return [2 /*return*/, []];
                        }
                        return [2 /*return*/, contents.map(function (content) { return content.Key; }).filter(function (key) { return key !== undefined; })];
                }
            });
        });
    };
    __decorate([
        (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", Promise)
    ], AwsS3.prototype, "uploadFile", null);
    __decorate([
        (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", Promise)
    ], AwsS3.prototype, "uploadContent", null);
    __decorate([
        (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", Promise)
    ], AwsS3.prototype, "downloadFile", null);
    __decorate([
        (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", Promise)
    ], AwsS3.prototype, "listFiles", null);
    return AwsS3;
}());
exports.AwsS3 = AwsS3;
//# sourceMappingURL=S3.js.map