/// <reference types="node" />
import { IAMQPConnection } from '../amqpConnectionFactory';
export interface IFileFilter {
    startsWith?: string;
    createdAtBefore?: Date;
}
export interface IFileOptions {
    contentType?: string;
}
export declare function saveFile(amqpConnection: IAMQPConnection, fileName: string, filePath: string, options?: IFileOptions): Promise<void>;
export declare function saveFileBuffer(amqpConnection: IAMQPConnection, fileName: string, fileBuffer: Buffer, options?: IFileOptions): Promise<void>;
export declare function deleteByFilter(amqpConnection: IAMQPConnection, filter: IFileFilter): Promise<void>;
export declare function bindDeleteByFilter(amqpConnection: IAMQPConnection, onDelete: (filter: IFileFilter, ack: () => void, nack: () => void) => void): Promise<() => Promise<void>>;
