/// <reference types="node" />
import IChannel from './IChannel';
import IAMQPPool from './IAMQPPool';
import IQueueOptions from './IQueueOptions';
export declare const REJECTED_QUEUE_PREFIX = "__rejected.";
export declare const DEFAULT_QUORUM_INITIAL_GROUP_SIZE = 3;
export default class ChannelProvider {
    private amqpPool;
    private amqplibConnection;
    private amqplibChannelMap;
    private responseProviderMap;
    constructor(amqpPool: IAMQPPool);
    getChannel(namespace: string, options?: IQueueOptions): Promise<IChannel<any>>;
    close(): Promise<void>;
    decodeMessageBuffer: (encodedMessageBuffer?: Buffer) => any;
    encodeMessageIntoBuffer(message: unknown): Buffer;
    private getAmqplibConnection;
    private createAmqplibSendOptions;
    private publish;
    private getAmqplibChannel;
    private getAmqplibConfirmChannel;
    private closeAmqplibChannel;
    private closeAmqplibConfirmChannel;
    private getOrCreateAmqplibChannel;
    private releaseAmqplibChannel;
    private tryCloseAmqplibChannelWhenUnused;
    private getResponseProvider;
    private assertRejectableQueue;
    private bindQueue;
    private unbindQueue;
}
