import { ChangeLogEntry } from './ChangeLogEntry';
import { getPipedInput, getGroupedChangeLog } from './helper';

const version = process.argv[2] || 'Unreleased';
const outputType = process.argv[3] || 'text';

(async function () {
	const changeLog = await getPipedInput();
	const groupedLog = getGroupedChangeLog(changeLog);
	let output;
	if (outputType === 'text') {
		const changedTypes = Object.keys(groupedLog[version] || {}) as ChangeLogEntry[];
		const releaseNotes = changedTypes.reduce(
			(notes, changeType) => [...notes, `${changeType}:`, ...(groupedLog[version]?.[changeType]?.map((note) => `- ${note}`) ?? []), ''],
			[] as string[],
		);
		output = releaseNotes.join('\n');
	} else if (outputType === 'groups') {
		output = typeof groupedLog[version] !== 'undefined' ? groupedLog[version] : {};
	}
	process.stdout.write(JSON.stringify(output));
})();

process.on('unhandledRejection', (error) => {
	throw error;
});
