"use strict";
var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);

// src/polyfills/AbortController.ts
function polyfillAbortController() {
  const SECRET = {};
  class AbortSignal extends EventTarget {
    constructor(secret) {
      super();
      __publicField(this, "_reason");
      __publicField(this, "_onabort", null);
      if (secret !== SECRET) {
        throw new TypeError("Illegal constructor.");
      }
    }
    get aborted() {
      return this._reason !== void 0;
    }
    get reason() {
      return this._reason;
    }
    set onabort(callback) {
      if (this._onabort) {
        this.removeEventListener("abort", this._onabort);
      }
      this._onabort = callback;
      this.addEventListener("abort", callback);
    }
    get onabort() {
      return this._onabort;
    }
    throwIfAborted() {
      if (this._reason !== void 0) {
        throw this._reason;
      }
    }
    __dispatchAbort(reason) {
      if (reason === void 0) {
        reason = new DOMException("The operation was aborted.");
      }
      this._reason = reason;
      this.dispatchEvent(new Event("abort"));
    }
    static abort(reason) {
      const signal = new AbortSignal(SECRET);
      signal._reason = reason;
      return signal;
    }
    // This methods is not spec complaint, because it requires WeakSet.
    // https://github.com/zloirock/core-js/issues/445
    static any(signals) {
      const signal = new AbortSignal(SECRET);
      for (const s of signals) {
        const onAbort = () => {
          signal.__dispatchAbort(s.reason);
          s.removeEventListener("abort", onAbort);
        };
        s.addEventListener("abort", onAbort);
      }
      return signal;
    }
    static timeout(timeoutMs) {
      if (timeoutMs < 0 || timeoutMs > Number.MAX_SAFE_INTEGER) {
        throw new TypeError("AbortSignal.timeout: Argument 1 is out of range for unsigned long long.");
      }
      const signal = new AbortSignal(SECRET);
      setTimeout(() => {
        signal.__dispatchAbort(new DOMException("The operation timed out.", "TimeoutError"));
      }, timeoutMs);
      return signal;
    }
  }
  class AbortController {
    constructor() {
      __publicField(this, "signal");
      this.signal = new AbortSignal(SECRET);
    }
    abort(reason) {
      this.signal.__dispatchAbort(reason);
    }
  }
  return { AbortController, AbortSignal };
}
(function() {
  const g = typeof globalThis !== "undefined" ? globalThis : typeof global !== "undefined" ? global : typeof window !== "undefined" ? window : typeof self !== "undefined" ? self : new Function("return this")();
  const polyfill = polyfillAbortController();
  if (g.AbortController === void 0) {
    globalThis.AbortController = polyfill.AbortController;
    globalThis.AbortSignal = polyfill.AbortSignal;
  }
  if (!g.AbortSignal.abort) {
    g.AbortSignal.abort = polyfill.AbortSignal.abort;
  }
  if (!g.AbortSignal.timeout) {
    g.AbortSignal.timeout = polyfill.AbortSignal.timeout;
  }
  if (!g.AbortSignal.any) {
    g.AbortSignal.any = polyfill.AbortSignal.any;
  }
})();
