"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __knownSymbol = (name, symbol) => (symbol = Symbol[name]) ? symbol : Symbol.for("Symbol." + name);
var __typeError = (msg) => {
  throw TypeError(msg);
};
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve4, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve4(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};
var __await = function(promise, isYieldStar) {
  this[0] = promise;
  this[1] = isYieldStar;
};
var __asyncGenerator = (__this, __arguments, generator) => {
  var resume = (k, v, yes, no) => {
    try {
      var x = generator[k](v), isAwait = (v = x.value) instanceof __await, done = x.done;
      Promise.resolve(isAwait ? v[0] : v).then((y) => isAwait ? resume(k === "return" ? k : "next", v[1] ? { done: y.done, value: y.value } : y, yes, no) : yes({ value: y, done })).catch((e) => resume("throw", e, yes, no));
    } catch (e) {
      no(e);
    }
  }, method = (k) => it[k] = (x) => new Promise((yes, no) => resume(k, x, yes, no)), it = {};
  return generator = generator.apply(__this, __arguments), it[__knownSymbol("asyncIterator")] = () => it, method("next"), method("throw"), method("return"), it;
};
var __yieldStar = (value) => {
  var obj = value[__knownSymbol("asyncIterator")], isAwait = false, method, it = {};
  if (obj == null) {
    obj = value[__knownSymbol("iterator")]();
    method = (k) => it[k] = (x) => obj[k](x);
  } else {
    obj = obj.call(value);
    method = (k) => it[k] = (v) => {
      if (isAwait) {
        isAwait = false;
        if (k === "throw") throw v;
        return v;
      }
      isAwait = true;
      return {
        done: false,
        value: new __await(new Promise((resolve4) => {
          var x = obj[k](v);
          if (!(x instanceof Object)) __typeError("Object expected");
          resolve4(x);
        }), 1)
      };
    };
  }
  return it[__knownSymbol("iterator")] = () => it, method("next"), "throw" in obj ? method("throw") : it.throw = (x) => {
    throw x;
  }, "return" in obj && method("return"), it;
};
var __forAwait = (obj, it, method) => (it = obj[__knownSymbol("asyncIterator")]) ? it.call(obj) : (obj = obj[__knownSymbol("iterator")](), it = {}, method = (key, fn) => (fn = obj[key]) && (it[key] = (arg) => new Promise((yes, no, done) => (arg = fn.call(obj, arg), done = arg.done, Promise.resolve(arg.value).then((value) => yes({ value, done }), no)))), method("next"), method("return"), it);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  BUNDLED_FILE_NAME: () => BUNDLED_FILE_NAME,
  BUNDLER_DIRECTORY_PATH: () => BUNDLER_DIRECTORY_PATH,
  BUNDLER_NAME: () => BUNDLER_NAME,
  Bundler: () => Bundler,
  ES_6_FOLDER_NAME: () => ES_6_FOLDER_NAME,
  TEMP_FOLDER_NAME: () => TEMP_FOLDER_NAME,
  getHtml5TestScript: () => getHtml5TestScript,
  globalObjectPlugin: () => globalObjectPlugin,
  nodePolyfillPlugin: () => nodePolyfillPlugin,
  packDist: () => packDist,
  sassPlugin: () => sassPlugin,
  stopwatch: () => stopwatch,
  svgrPlugin: () => svgrPlugin
});
module.exports = __toCommonJS(src_exports);

// src/Bundler.ts
var fs2 = __toESM(require("fs-extra"));
var path2 = __toESM(require("path"));
var import_child_process = require("child_process");
var import_glob = require("glob");

// src/utils/index.ts
var import_core = require("@swc/core");
var import_debug = __toESM(require("debug"));
var fs = __toESM(require("fs"));
var path = __toESM(require("path"));

// src/IBundler.ts
var BUNDLER_NAME = "signageOS Assets Bundler";

// src/utils/index.ts
var debug = (0, import_debug.default)("@signageos/lib:Bundler");
function addLiveReloading(source, dest, origin = "") {
  return __async(this, null, function* () {
    const indexFile = yield fs.promises.readFile(source);
    yield fs.promises.writeFile(
      dest,
      indexFile.toString("utf-8").replace(
        "</body>",
        `<script>new EventSource("${origin}/esbuild").addEventListener('change', () => location.reload())</script></body>`
      )
    );
  });
}
function handleBuildMode(ctx) {
  return __async(this, null, function* () {
    console.log("ESBuild is rebuilding...");
    const { metafile } = yield ctx.rebuild();
    if (metafile) {
      fs.promises.writeFile("./meta.json", JSON.stringify(metafile));
    }
    yield ctx.dispose();
  });
}
function handleWatchMode(ctx, mode, serveOptions) {
  return __async(this, null, function* () {
    console.info("ESBuild is watching...");
    yield ctx.rebuild();
    yield ctx.watch();
    if (mode === "serve") {
      const { port } = yield ctx.serve(serveOptions);
      console.info(`Serving files on http://localhost:${port}`);
    }
  });
}
function printBanner(config) {
  const entries = Object.entries(config);
  const maxKeyLength = Math.max(...entries.map(([key]) => key.length));
  const lines = entries.map(([key, value]) => {
    const paddedKey = key.padEnd(maxKeyLength + 2, " ");
    return `${paddedKey}: ${String(value)}`;
  });
  console.log(`
${BUNDLER_NAME}
${lines.join("\n")}
`);
}
function resolveConfig({ outdir, parameters, argv }) {
  const mode = argv.includes("--serve") ? "serve" : argv.includes("--watch") ? "watch" : "build";
  const config = {
    environment: parameters.environment,
    NODE_ENV: parameters.NODE_ENV,
    outdir,
    mode,
    typeCheck: !argv.includes("--skipTypeCheck") && mode === "build"
  };
  return config;
}
function transpileFiles(files, options) {
  return __async(this, null, function* () {
    const promises6 = [];
    try {
      for (var iter = __forAwait(files), more, temp, error; more = !(temp = yield iter.next()).done; more = false) {
        const file = temp.value;
        promises6.push(
          (() => __async(this, null, function* () {
            if (!file.endsWith(".js")) {
              return;
            }
            debug(`Transpiling the file ${file} to es5`);
            const source = yield fs.promises.readFile(file);
            const output = yield (0, import_core.transform)(source.toString("utf-8"), options);
            yield fs.promises.writeFile(file, output.code);
          }))()
        );
      }
    } catch (temp) {
      error = [temp];
    } finally {
      try {
        more && (temp = iter.return) && (yield temp.call(iter));
      } finally {
        if (error)
          throw error[0];
      }
    }
    yield Promise.all(promises6);
  });
}
function transpileToES5(_0) {
  return __async(this, arguments, function* ({ outdir, options = {} }) {
    const extendedOptions = __spreadValues({
      isModule: false
    }, options);
    yield transpileFiles(walk(outdir), extendedOptions);
  });
}
function walk(root, p = ".") {
  return __asyncGenerator(this, null, function* () {
    if ((yield new __await(fs.promises.stat(root))).isFile()) {
      yield root;
      return;
    }
    const dir = yield new __await(fs.promises.readdir(path.join(root, p), { withFileTypes: true }));
    for (const e of dir) {
      if (e.isDirectory()) {
        yield* __yieldStar(walk(root, path.join(p, e.name)));
      }
      if (e.isFile()) {
        yield path.join(root, p, e.name);
      }
    }
  });
}

// src/Bundler.ts
var BUNDLED_FILE_NAME = "bundle.js";
var BUNDLER_DIRECTORY_PATH = "./node_modules/@signageos/lib/dist/ESBuild/";
var ES_6_FOLDER_NAME = "es6";
var TEMP_FOLDER_NAME = "temp";
var Bundler = class {
  constructor({ outdir, parameters, serveOptions, argv }) {
    __publicField(this, "DEFAULT_CHROME_VERSION", 32);
    __publicField(this, "config");
    __publicField(this, "serveOptions", {
      port: 3e3
    });
    // ts generates better types w/o typedef
    // eslint-disable-next-line @typescript-eslint/typedef
    __publicField(this, "esbuildOptions", {
      outdir: "",
      bundle: true,
      format: "iife",
      logLevel: "info",
      sourcemap: true,
      target: "es6",
      treeShaking: true
    });
    const config = resolveConfig({ outdir, parameters, argv });
    printBanner(config);
    this.config = config;
    this.serveOptions = __spreadValues(__spreadValues({}, this.serveOptions), serveOptions);
    this.esbuildOptions = __spreadProps(__spreadValues({}, this.esbuildOptions), { outdir });
  }
  static copyAssetsToEs6Folder(expression = "src/**/*.{sass,svg}") {
    return __async(this, null, function* () {
      try {
        const files = yield (0, import_glob.glob)(expression);
        const copyPromises = files.map((file) => {
          const destinationPath = ES_6_FOLDER_NAME + "/" + file.substr("src/".length);
          return fs2.copy(file, destinationPath);
        });
        yield Promise.all(copyPromises);
      } catch (error) {
        console.error(`Failed to copy assets to ES6 folder: ${error}`);
        throw error;
      }
    });
  }
  // Converts the input to a JSON string.
  static enc(x) {
    try {
      return x === void 0 ? "undefined" : JSON.stringify(x);
    } catch (error) {
      console.error(`Failed to stringify JSON: ${error}`);
      throw error;
    }
  }
  static prepareEs6Folder() {
    return __async(this, null, function* () {
      try {
        yield fs2.mkdir("./" + ES_6_FOLDER_NAME, { recursive: true });
      } catch (error) {
        console.error(`Failed to prepare ES6 folder: ${error}`);
        throw error;
      }
    });
  }
  // Bundles source files to `outdir` and watch & serve them in watch mode
  build(ctx, watchInsteadOfServe = false) {
    return __async(this, null, function* () {
      try {
        let mode = this.config.mode;
        mode = mode === "serve" && watchInsteadOfServe ? "watch" : mode;
        if (mode === "watch" || mode === "serve") {
          const serveOptions = {
            servedir: this.config.outdir,
            port: this.serveOptions.port
          };
          yield handleWatchMode(ctx, mode, serveOptions);
        } else {
          yield handleBuildMode(ctx);
        }
      } catch (error) {
        console.error(`Failed to build: ${error}`);
        throw error;
      }
    });
  }
  compileTypescript() {
    return __async(this, arguments, function* (tscArgs = ["-p", "tsconfig.es6.json"], force) {
      const shouldTypecheck = force || this.config.typeCheck;
      if (!shouldTypecheck) {
        console.log("Skipping typescript compilation because of the --serve or --skipTypeCheck flag.");
        return;
      }
      try {
        const tsc = (0, import_child_process.spawn)("tsc", tscArgs, { stdio: "inherit" });
        yield new Promise((resolve4, reject) => {
          tsc.on("close", (code) => __async(this, null, function* () {
            if (code !== 0) {
              reject(new Error(`tsc process exited with code ${code}`));
            } else {
              resolve4();
            }
          }));
          tsc.on("error", (error) => {
            reject(new Error(`Failed to start tsc process: ${error.message}`));
          });
        });
      } catch (error) {
        console.error(`Failed to compile TypeScript: ${error}`);
        throw error;
      }
    });
  }
  // Transpiles all js files in `outdir` to ES5 with SWC
  transpileToES5() {
    return __async(this, arguments, function* (options = {}) {
      try {
        yield transpileToES5({ outdir: this.config.outdir, options });
      } catch (error) {
        console.error(`Error during transpilation to ES5: ${error}`);
        throw error;
      }
    });
  }
  // Writes index.html file to `outdir` folder and enables hot reload in the serve mode
  writeIndexFile(source, destInOutdir = "index.html", origin = "") {
    return __async(this, null, function* () {
      const dest = path2.resolve(this.config.outdir, destInOutdir);
      try {
        console.info(`Writing index file "${source}" to ${dest}`);
        yield fs2.promises.mkdir(this.config.outdir, { recursive: true });
        if (["watch", "serve"].includes(this.config.mode)) {
          yield addLiveReloading(source, dest, origin);
        } else {
          yield fs2.promises.copyFile(source, dest);
        }
      } catch (error) {
        console.error(`Failed to write index file: ${error}`);
        throw error;
      }
    });
  }
  cleanOutDir() {
    return __async(this, arguments, function* (preservedFiles = [BUNDLED_FILE_NAME, BUNDLED_FILE_NAME + ".map"]) {
      try {
        let files = [];
        if (yield fs2.pathExists(this.config.outdir)) {
          files = yield fs2.readdir(this.config.outdir);
        }
        for (const file of files) {
          if (!preservedFiles.includes(file)) {
            yield fs2.rm(path2.join(this.config.outdir, file), { recursive: true, force: true });
          }
        }
      } catch (error) {
        console.error(`Failed to clean dist folder: ${error}`);
        throw error;
      }
    });
  }
};

// src/html5test/html5TestScript.ts
var fs3 = __toESM(require("fs"));
var swc = __toESM(require("@swc/core"));

// src/html5test/loadWhichBrowser.ts
function loadWhichBrowser(cb) {
  var callback = cb;
  var p = [], w = window, d = document, e = f = 0;
  p.push("ua=" + encodeURIComponent(navigator.userAgent));
  e |= w.ActiveXObject ? 1 : 0;
  e |= w.opera ? 2 : 0;
  e |= w.chrome ? 4 : 0;
  e |= "getBoxObjectFor" in d || "mozInnerScreenX" in w ? 8 : 0;
  e |= "WebKitCSSMatrix" in w || "WebKitPoint" in w || "webkitStorageInfo" in w || "webkitURL" in w ? 16 : 0;
  e |= e & 16 && {}.toString.toString().indexOf("\n") === -1 ? 32 : 0;
  p.push("e=" + e);
  f |= "sandbox" in d.createElement("iframe") ? 1 : 0;
  f |= "WebSocket" in w ? 2 : 0;
  f |= w.Worker ? 4 : 0;
  f |= w.applicationCache ? 8 : 0;
  f |= w.history && history.pushState ? 16 : 0;
  f |= d.documentElement.webkitRequestFullScreen ? 32 : 0;
  f |= "FileReader" in w ? 64 : 0;
  p.push("f=" + f);
  p.push("r=" + Math.random().toString(36).substring(7));
  p.push("w=" + screen.width);
  p.push("h=" + screen.height);
  var servers = ["api.whichbrowser.net", "backup.whichbrowser.net"];
  var timeout = null;
  function load() {
    if (typeof WhichBrowser != "undefined") {
      return;
    }
    var server = servers.shift();
    if (server) {
      var script = document.createElement("script");
      script.src = "https://" + server + "/rel/detect.js?" + p.join("&");
      document.getElementsByTagName("head")[0].appendChild(script);
      wait();
    }
  }
  function wait() {
    if (!timeout) {
      timeout = window.setTimeout(load, 3e3);
    }
    if (typeof WhichBrowser == "undefined") {
      window.setTimeout(wait, 100);
    } else {
      window.clearTimeout(timeout);
      callback();
    }
  }
  load();
}

// src/html5test/html5TestScript.ts
var getHtml5TestScript = (enginePath = "./node_modules/html5test/scripts/9/engine.js") => __async(void 0, null, function* () {
  const engine = yield fs3.promises.readFile(enginePath).then((b) => b.toString());
  const script = `
    (function () {
      var resolve = window.__SOS_HTML5TEST_RESOLVE;
      delete window.__SOS_HTML5TEST_RESOLVE;

      if(typeof resolve === "function") {
        ${/* This script can't run in strict mode, so this prevent undeclared variables to be assigned to window object */
  ""}
        var f, Test, Test9, passed;

        ${loadWhichBrowser.toString()}
        ${engine}

        loadWhichBrowser(function () {
          ${/* WhichBrowser is injected be external script so it need to stay on window */
  ""}
          window.Browsers = new window.WhichBrowser({
            useFeatures: true,
            detectCamouflage: true,
          });

          new Test(function (result) {
            resolve(result);
          });
        });
      }
    })();
  `;
  const minified = yield swc.transform(script, { minify: false, jsc: { target: "es5" } });
  return Bundler.enc(minified.code);
});

// src/pack.ts
var fs4 = __toESM(require("fs-extra"));
var path3 = __toESM(require("path"));
var import_node_child_process = require("child_process");
var util = __toESM(require("util"));
var tmp = __toESM(require("tmp"));
var tar = __toESM(require("tar"));
var execPromise = util.promisify(import_node_child_process.exec);
var packDist = (options) => __async(void 0, null, function* () {
  if (options.environment === "dev") {
    const timestampNumber = (/* @__PURE__ */ new Date()).toISOString().replace(/[^\d]/gi, "").substr(0, 14);
    const devVersion = (options.getVersion ? options.getVersion() : "99.0.0-dev") + "." + timestampNumber;
    const tmpDir = tmp.dirSync().name;
    yield fs4.copy(path3.join(options.rootPath, "dist"), path3.join(tmpDir, "package", "dist"));
    yield fs4.copy(path3.join(options.rootPath, "README.md"), path3.join(tmpDir, "package", "README.md"));
    const configPath = path3.join(options.rootPath, "package.json");
    const configContents = yield fs4.readJson(configPath);
    configContents.version = devVersion;
    yield fs4.writeJson(path3.join(tmpDir, "package", "package.json"), configContents, { spaces: 2 });
    const tarballDir = path3.join(options.packagesPath, options.name, devVersion);
    const tarballFileName = options.name.replace(/^@/, "").replace(/\//g, "-") + "-" + devVersion + ".tgz";
    yield fs4.ensureDir(tarballDir);
    yield tar.c(
      {
        gzip: true,
        file: path3.join(tarballDir, tarballFileName),
        cwd: tmpDir
      },
      ["package"]
    );
    yield packDependencies(options);
    console.info("Tarball release " + tarballFileName);
  }
});
function packDependencies(options) {
  return __async(this, null, function* () {
    const configLockPath = path3.join(options.rootPath, "package-lock.json");
    const configLockContents = yield fs4.readJson(configLockPath);
    const dependencies = options.dependencies || [];
    for (const dependency of dependencies) {
      const dependencyVersion = "dependencies" in configLockContents ? (
        // lockfileVersion 0 and 1
        configLockContents.dependencies[dependency].version
      ) : (
        // lockfileVersion 2 and 3
        configLockContents.packages["node_modules/" + dependency].version
      );
      const dependencyVersionPath = path3.join(options.packagesPath, dependency, dependencyVersion);
      if (!(yield fs4.pathExists(dependencyVersionPath))) {
        const { stdout } = yield execPromise(`npm pack ${dependency}@${dependencyVersionPath}`);
        const fileName = stdout.trim();
        yield fs4.ensureDir(dependencyVersionPath);
        yield fs4.move(path3.join(options.rootPath, fileName), path3.join(dependencyVersionPath, fileName));
      }
    }
  });
}

// src/plugins/sass.ts
var path4 = __toESM(require("path"));
var fs5 = __toESM(require("fs"));
var import_sass = require("sass");
var import_css_tree = require("css-tree");
var import_crypto = require("crypto");
var sassPlugin = () => ({
  name: "sass",
  setup(build) {
    return __async(this, null, function* () {
      build.onResolve({ filter: /\.sass$/ }, (args) => ({
        path: path4.resolve(args.resolveDir, args.path),
        namespace: "sass"
      }));
      build.onLoad({ filter: /.*/, namespace: "sass" }, (args) => __async(this, null, function* () {
        const compiled = yield (0, import_sass.compileStringAsync)((yield fs5.promises.readFile(args.path)).toString("utf-8"), {
          syntax: "indented",
          url: new URL("file://" + args.path)
        });
        if (args.path.endsWith(".module.sass")) {
          const ast = (0, import_css_tree.parse)(compiled.css);
          const classMap = /* @__PURE__ */ new Map();
          (0, import_css_tree.walk)(ast, {
            visit: "ClassSelector",
            enter(node) {
              const transformed = `m-${node.name}-${(0, import_crypto.createHash)("md5").update(args.path).digest("hex").slice(0, 10)}`;
              classMap.set(node.name, transformed);
              node.name = transformed;
            }
          });
          return {
            contents: `
            import "data:text/css,${encodeURI((0, import_css_tree.generate)(ast))}";
            const result = ${JSON.stringify(Object.fromEntries([...Array.from(classMap)].map(([k, v]) => [k, v])))};
            export default result;
          `
          };
        } else {
          return {
            contents: compiled.css,
            loader: "css"
          };
        }
      }));
    });
  }
});

// src/plugins/svgr.ts
var import_core2 = require("@svgr/core");
var fs6 = __toESM(require("fs"));
var path5 = __toESM(require("path"));
var svgrPlugin = () => ({
  name: "svgr",
  setup(build) {
    return __async(this, null, function* () {
      build.onResolve({ filter: /\.svg$/ }, (args) => ({
        path: path5.resolve(args.resolveDir, args.path),
        namespace: "svgr"
      }));
      build.onLoad({ filter: /.*/, namespace: "svgr" }, (args) => __async(this, null, function* () {
        const svg = (yield fs6.promises.readFile(args.path)).toString("utf-8");
        const fileName = path5.basename(args.path, ".svg");
        const componentName = fileName.charAt(0).toUpperCase() + fileName.slice(1);
        const contents = yield (0, import_core2.transform)(svg, { icon: true, plugins: ["@svgr/plugin-jsx"] }, { componentName });
        return {
          contents,
          loader: "jsx",
          resolveDir: process.cwd()
        };
      }));
    });
  }
});

// src/plugins/nodePolyfillPlugin.ts
var import_module = require("module");
var import_meta = {};
var resolvePath = (path6) => {
  const require2 = typeof require === "undefined" ? (0, import_module.createRequire)(import_meta.url) : require;
  return require2.resolve(path6);
};
var nodePolyfillPlugin = () => ({
  name: "node-polyfill",
  setup: ({ initialOptions }) => {
    var _a;
    const nodeShimPath = resolvePath("@signageos/lib-bundler/shims/node");
    const noopPath = resolvePath("@signageos/lib-bundler/alias/noop");
    initialOptions.inject = [...(_a = initialOptions.inject) != null ? _a : [], nodeShimPath];
    initialOptions.alias = __spreadProps(__spreadValues({}, initialOptions.alias), {
      assert: "assert",
      child_process: noopPath,
      crypto: "crypto-browserify",
      os: "os-browserify/browser",
      path: "path-browserify",
      net: noopPath,
      querystring: "querystring-es3",
      stream: "stream-browserify",
      util: "util",
      events: "events",
      url: "url",
      buffer: "buffer"
    });
  }
});

// src/plugins/globalObjectPlugin.ts
var globalObjectPlugin = () => ({
  name: "global-object-plugin",
  setup(build) {
    build.onResolve({ filter: /^virtual-global-object$/ }, (args) => ({
      path: args.path,
      namespace: "global-object"
    }));
    build.onLoad({ filter: /.*/, namespace: "global-object" }, () => ({
      contents: `
                export default typeof globalThis !== 'undefined'
                    ? globalThis
                    : typeof global !== 'undefined'
                        ? global
                        : typeof window !== 'undefined'
                            ? window
                            : typeof self !== 'undefined'
                                ? self
                                : new Function('return this')();
            `,
      loader: "js"
    }));
    build.initialOptions.inject = build.initialOptions.inject || [];
    build.initialOptions.inject.push("virtual-global-object");
  }
});

// src/utils/stopwatch.ts
function stopwatch(label, cb) {
  return __async(this, null, function* () {
    const timeLabel = "\u{1F3C1} " + label;
    console.info("\u{1F680} " + label);
    console.time(timeLabel);
    if (Array.isArray(cb)) {
      yield Promise.all(cb.map((x) => typeof x === "function" ? x() : x));
    } else {
      yield cb();
    }
    console.timeEnd(timeLabel);
  });
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  BUNDLED_FILE_NAME,
  BUNDLER_DIRECTORY_PATH,
  BUNDLER_NAME,
  Bundler,
  ES_6_FOLDER_NAME,
  TEMP_FOLDER_NAME,
  getHtml5TestScript,
  globalObjectPlugin,
  nodePolyfillPlugin,
  packDist,
  sassPlugin,
  stopwatch,
  svgrPlugin
});
