'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _NavTree = require('./NavTree');

var _NavTree2 = _interopRequireDefault(_NavTree);

var _NavFunctions = require('./NavFunctions');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Nav = function (_React$PureComponent) {
  _inherits(Nav, _React$PureComponent);

  function Nav(props) {
    _classCallCheck(this, Nav);

    var _this = _possibleConstructorReturn(this, (Nav.__proto__ || Object.getPrototypeOf(Nav)).call(this, props));

    _this.state = {
      focused: false
    };
    return _this;
  }

  _createClass(Nav, [{
    key: 'getChildContext',
    value: function getChildContext() {
      return {
        tree: this.tree
      };
    }
  }, {
    key: 'componentWillMount',
    value: function componentWillMount() {
      if (this.props.tree) {
        // root tree
        this.tree = this.props.tree;
      } else if (this.context.tree) {
        // child tree
        var id = this.props.navId;
        this.tree = this.context.tree.addNode(id);
      } else {
        if (process.env.NODE_ENV !== 'production') {
          console.warn('No navigation tree provided. `NavTree` instance should be passed as a `tree` prop to the root (top level) `Nav` component');
        }
        return;
      }

      this.tree.resolveFunc = this.resolveFunc.bind(this);
      this.tree.onNavCallback = this.onNav.bind(this);

      if (this.props.defaultFocused) {
        this.tree.focus();
      }
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      if (this.tree.parent) {
        this.tree.parent.removeNode(this.tree.id);
      }
    }
  }, {
    key: 'resolveFunc',
    value: function resolveFunc(event, navTree, focusedNode) {
      if (!this.props.func) {
        if (navTree.nodesId.length > 1) return (0, _NavFunctions.navDynamic)(event, navTree, focusedNode);else return this.state.focused ? false : navTree.nodesId.length > 0 ? navTree.nodesId[0] : null;
      } else {
        return this.props.func(event, navTree, focusedNode);
      }
    }
  }, {
    key: 'onNav',
    value: function onNav(path) {
      this.setState({
        focused: path !== false
      });

      if (this.props.onNav) {
        this.props.onNav(path);
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          component = _props.component,
          children = _props.children,
          className = _props.className,
          focusedClass = _props.focusedClass,
          tree = _props.tree,
          navId = _props.navId,
          func = _props.func,
          onNav = _props.onNav,
          defaultFocused = _props.defaultFocused,
          restProps = _objectWithoutProperties(_props, ['component', 'children', 'className', 'focusedClass', 'tree', 'navId', 'func', 'onNav', 'defaultFocused']);

      var Component = component || this.constructor.defaultComponent;

      if (this.state.focused) {
        if (focusedClass === undefined) focusedClass = this.constructor.defaultFocusedClass;
        className = (className || '') + ' ' + focusedClass;
      }

      return _react2.default.createElement(
        Component,
        _extends({ ref: function ref(_ref) {
            if (_this2.tree) _this2.tree.el = _ref;
          }, className: className }, restProps),
        children
      );
    }
  }]);

  return Nav;
}(_react2.default.PureComponent);

exports.default = Nav;


Nav.defaultComponent = 'div';

Nav.defaultFocusedClass = 'nav-focused';

Nav.contextTypes = {
  tree: _propTypes2.default.instanceOf(_NavTree2.default)
};

Nav.childContextTypes = {
  tree: _propTypes2.default.instanceOf(_NavTree2.default)
};

Nav.propTypes = {
  navId: _propTypes2.default.string,
  func: _propTypes2.default.func,
  focusedClass: _propTypes2.default.string,
  component: _propTypes2.default.oneOfType([_propTypes2.default.func, _propTypes2.default.string]),
  tree: _propTypes2.default.instanceOf(_NavTree2.default),
  onNav: _propTypes2.default.func,
  defaultFocused: _propTypes2.default.bool,
  children: _propTypes2.default.node,
  className: _propTypes2.default.string
};