import { TextDecoder } from '../ponyfill/TextDecoder';
import { TextEncoder } from '../ponyfill/TextEncoder';
import { polyfillFetch } from './fetch';

if (window.TextEncoder === undefined) {
	window.TextEncoder = TextEncoder;
}

if (window.TextDecoder === undefined) {
	window.TextDecoder = TextDecoder;
}

if (typeof Blob.prototype.arrayBuffer !== 'function') {
	Blob.prototype.arrayBuffer = function () {
		return new Promise<ArrayBuffer>((resolve, reject) => {
			const reader = new FileReader();
			reader.onloadend = () => resolve(reader.result as ArrayBuffer);
			reader.onerror = reject;
			reader.readAsArrayBuffer(this);
		});
	};
}

polyfillFetch();
