import type { IBundledApplet } from './Front/Applet/BundledApplet/bundledAppletActions';
import { EmulatorParameters } from '../config/parameters.mjs';

// Non-existent constant which will be replaced by webpack
declare const __SOS_BUILDTIME_PARAMETERS__: EmulatorParameters;

// Window properties available in the emulator
declare global {
	interface Window {
		/** Global placeholder variable for emulator from CLI or snippet */
		__SOS_BUNDLED_APPLET?: IBundledApplet;
		/** Global placeholder variable for emulator from CLI or snippet */
		__SOS_AUTO_VERIFICATION?: {
			organizationUid: string;
		};
		__SOS_SUBSCRIPTION_TYPE?: string;
	}
	// eslint-disable-next-line no-var
	var window: Window & typeof globalThis;
}

const getWindowValue = (key: keyof Window) => {
	if (typeof window !== 'undefined' && typeof window[key] !== 'undefined') {
		return window[key];
	}
};

const getParameters = () => {
	const p = __SOS_BUILDTIME_PARAMETERS__;

	if (getWindowValue('__SOS_BUNDLED_APPLET')) {
		p.bundledApplet = getWindowValue('__SOS_BUNDLED_APPLET');
	}

	if (getWindowValue('__SOS_SUBSCRIPTION_TYPE')) {
		p.subscriptionType = getWindowValue('__SOS_SUBSCRIPTION_TYPE');
	}

	if (getWindowValue('__SOS_AUTO_VERIFICATION')) {
		p.autoVerification = getWindowValue('__SOS_AUTO_VERIFICATION');
	}

	return p;
};

export const parameters = getParameters();
