import { IPrepareOptions } from './IVideoPlayer';

export default class VideoOptions<TOptions extends IPrepareOptions = IPrepareOptions> {
	private videoOptions: Record<string, TOptions>;

	constructor() {
		this.videoOptions = {};
	}

	public getOptions(uri: string, x: number, y: number, width: number, height: number) {
		const optionsKey = this.getKeyForProperties(uri, x, y, width, height);
		return this.hasOptions(uri, x, y, width, height) ? this.videoOptions[optionsKey] : undefined;
	}

	public setOptions(uri: string, x: number, y: number, width: number, height: number, options: TOptions): void {
		const optionsKey = this.getKeyForProperties(uri, x, y, width, height);
		this.videoOptions[optionsKey] = options;
	}

	public clearOptions(uri: string, x: number, y: number, width: number, height: number) {
		const optionsKey = this.getKeyForProperties(uri, x, y, width, height);
		if (this.hasOptions(uri, x, y, width, height)) {
			delete this.videoOptions[optionsKey];
		}
	}

	public hasOptions(uri: string, x: number, y: number, width: number, height: number) {
		const optionsKey = this.getKeyForProperties(uri, x, y, width, height);
		return this.videoOptions?.hasOwnProperty(optionsKey);
	}

	public getKeyForProperties(uri: string, x: number, y: number, width: number, height: number): string {
		return `${uri}_${x}_${y}_${width}_${height}`;
	}
}
