import { createProgressiveWait } from '@signageos/lib/dist/Timer/progressiveWait';

interface Options {
	/**
	 * Defines how many times it should retry the function.
	 * The value -1 means infinite retries.
	 */
	count: number;
	/** @see createProgressiveWait */
	initialTimeoutMs: number;
	/** @see createProgressiveWait */
	progressiveMultiplier?: number;
	/** @see createProgressiveWait */
	maxTimeoutMs?: number;
}

export function retriable<TArgs extends unknown[], TThis extends object>(options: Options) {
	return function (_target: unknown, _propertyKey: string, descriptor: PropertyDescriptor) {
		const originalMethod = descriptor.value;
		descriptor.value = async function (this: TThis, ...args: TArgs) {
			const progressiveWait = createProgressiveWait(options.initialTimeoutMs, options.progressiveMultiplier, options.maxTimeoutMs);
			for (let i = 0; i < options.count || options.count === -1; i++) {
				try {
					return await originalMethod.apply(this, args);
				} catch (error) {
					console.error(`Retrying ${originalMethod.name}(${args}) failed for ${i + 1} time`, error);
					await progressiveWait.wait();
				}
			}
		};
	};
}
