import { EventEmitter } from 'events';

export function resolveOnceEvent(eventEmitter: EventEmitter, event: string) {
	return new Promise<void>((resolve: () => void) => {
		eventEmitter.once(event, resolve);
	});
}

export function rejectOnceEvent(eventEmitter: EventEmitter, event: string) {
	return new Promise<void>((_resolve: () => void, reject: (error: any) => void) => {
		eventEmitter.once(event, reject);
	});
}
