import wait from '@signageos/lib/dist/Timer/wait';
import Debug from 'debug';

const debug = Debug('@signageos/front-display:Util:processCallback');

export type ICallback = void | undefined | (() => Promise<unknown>);

export const CALLBACK_TIMEOUT_MS = 1e3;

export default async function processCallback(
	callback: ICallback,
	options: {
		debugTag?: string;
	} = {},
): Promise<void> {
	const { debugTag } = options;
	if (!callback) {
		return;
	}

	debug(`Finalize callback after ${debugTag} will be called after ${CALLBACK_TIMEOUT_MS} ms`);
	await wait(CALLBACK_TIMEOUT_MS);
	await callback();
}
