import { ProprietaryTimer, NativeTimer, IShortWeekdayTimer } from '@signageos/common-types/dist/Device/Settings/DeviceSettings';
import { ProprietaryTimerType } from '@signageos/common-types/dist/Device/Timer/ProprietaryTimerType';
import { NativeTimerType } from '@signageos/common-types/dist/Device/Timer/NativeTimerType';
import { ILegacyTimer } from '@signageos/lib/dist/Timer/Power/PowerTimerSettings';
import CommonTimerType from '@signageos/lib/dist/Timer/Power/PowerTimerType';

/**
 * @deprecated use Record with `ProprietaryTimerType` or `NativeTimerType` from `@signageos/common-types`
 */
export type TimersSettingsObject = { [timerType in CommonTimerType]: ILegacyTimer };

export type TimerSettingsInternalStorage<T extends ILegacyTimer | IShortWeekdayTimer = ILegacyTimer | IShortWeekdayTimer> = Partial<
	Record<`TIMER_${number}`, T>
>;

export default interface ITimerStorage<TKey extends ProprietaryTimerType | NativeTimerType, T extends IShortWeekdayTimer> {
	/** @deprecated use replaceTimerSettings instead */
	replaceTimers(timers: TimersSettingsObject): Promise<void>;
	/** @deprecated use setTimerSettings instead */
	setTimer(timer: ILegacyTimer): Promise<void>;
	/** @deprecated use getTimerSettings instead */
	getTimer(timerType: CommonTimerType): Promise<ILegacyTimer | undefined>;
	/** @deprecated use getTimerSettings instead */
	getTimers(): Promise<TimersSettingsObject>;
	/** @deprecated use deleteTimerSettings instead */
	deleteTimer(timerType: CommonTimerType): Promise<void>;

	getShortTimers(): Promise<Record<TKey, T>>;
	getShortTimer(timerType: TKey): Promise<T | undefined>;
	setShortTimer(timer: T): Promise<void>;
	replaceShortTimers(timers: Record<TKey, T>): Promise<void>;
	deleteShortTimer(timerType: TKey): Promise<void>;
}

export type INativeTimerStorage = ITimerStorage<NativeTimerType, NativeTimer>;
export type IProprietaryTimerStorage = ITimerStorage<ProprietaryTimerType, ProprietaryTimer>;
export type IAnyTimerStorage = INativeTimerStorage | IProprietaryTimerStorage;
